/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.flags;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.yahoo.vespa.flags.Flag;
import com.yahoo.vespa.flags.FlagId;
import com.yahoo.vespa.flags.FlagSource;
import com.yahoo.yolean.Exceptions;
import java.util.function.Function;

public class JacksonFlag<T>
implements Flag {
    private static final ObjectMapper mapper = new ObjectMapper();
    private final FlagId id;
    private final Class<T> jacksonClass;
    private final T defaultValue;
    private final FlagSource source;

    public static <T> Function<FlagSource, JacksonFlag<T>> createUnbound(String flagId, Class<T> jacksonClass, T defaultValue) {
        return JacksonFlag.createUnbound(new FlagId(flagId), jacksonClass, defaultValue);
    }

    public static <T> Function<FlagSource, JacksonFlag<T>> createUnbound(FlagId id, Class<T> jacksonClass, T defaultValue) {
        return source -> new JacksonFlag<Object>(id, (Class<Object>)jacksonClass, defaultValue, (FlagSource)source);
    }

    public JacksonFlag(String flagId, Class<T> jacksonClass, T defaultValue, FlagSource source) {
        this(new FlagId(flagId), jacksonClass, defaultValue, source);
    }

    public JacksonFlag(FlagId id, Class<T> jacksonClass, T defaultValue, FlagSource source) {
        this.id = id;
        this.jacksonClass = jacksonClass;
        this.defaultValue = defaultValue;
        this.source = source;
    }

    @Override
    public FlagId id() {
        return this.id;
    }

    public T value() {
        return (T)this.source.getString(this.id).map(string -> Exceptions.uncheck(() -> mapper.readValue(string, this.jacksonClass))).orElse(this.defaultValue);
    }

    public String toString() {
        return "JacksonFlag{id=" + this.id + ", jacksonClass=" + this.jacksonClass + ", defaultValue=" + this.defaultValue + ", source=" + this.source + '}';
    }
}

