/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.flags;

import com.yahoo.vespa.flags.Flag;
import com.yahoo.vespa.flags.FlagId;
import com.yahoo.vespa.flags.FlagSource;
import java.util.function.Function;

public class IntFlag
implements Flag {
    private final FlagId id;
    private final int defaultValue;
    private final FlagSource source;

    public static Function<FlagSource, IntFlag> createUnbound(String flagId, int defaultValue) {
        return IntFlag.createUnbound(new FlagId(flagId), defaultValue);
    }

    public static Function<FlagSource, IntFlag> createUnbound(FlagId id, int defaultValue) {
        return source -> new IntFlag(id, defaultValue, (FlagSource)source);
    }

    public IntFlag(String flagId, int defaultValue, FlagSource source) {
        this(new FlagId(flagId), defaultValue, source);
    }

    public IntFlag(FlagId id, int defaultValue, FlagSource source) {
        this.id = id;
        this.defaultValue = defaultValue;
        this.source = source;
    }

    @Override
    public FlagId id() {
        return this.id;
    }

    public int value() {
        return this.source.getString(this.id).map(String::trim).map(Integer::parseInt).orElse(this.defaultValue);
    }

    public String toString() {
        return "IntFlag{id=" + this.id + ", defaultValue=" + this.defaultValue + ", source=" + this.source + '}';
    }
}

