/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.flags;

import com.google.inject.Inject;
import com.yahoo.vespa.flags.FlagId;
import com.yahoo.vespa.flags.FlagSource;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Optional;

public class FileFlagSource
implements FlagSource {
    static final String FLAGS_DIRECTORY = "/etc/vespa/flags";
    private final Path flagsDirectory;

    @Inject
    public FileFlagSource() {
        this(FileSystems.getDefault());
    }

    public FileFlagSource(FileSystem fileSystem) {
        this(fileSystem.getPath(FLAGS_DIRECTORY, new String[0]));
    }

    public FileFlagSource(Path flagsDirectory) {
        this.flagsDirectory = flagsDirectory;
    }

    @Override
    public Optional<String> getString(FlagId id) {
        return this.getBytes(id).map(bytes -> new String((byte[])bytes, StandardCharsets.UTF_8));
    }

    public Optional<byte[]> getBytes(FlagId id) {
        try {
            return Optional.of(Files.readAllBytes(this.getPath(id)));
        }
        catch (NoSuchFileException e) {
            return Optional.empty();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private Path getPath(FlagId id) {
        return this.flagsDirectory.resolve(id.toString());
    }

    public String toString() {
        return "FileFlagSource{" + this.flagsDirectory + '}';
    }
}

