/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.filedistribution;

import com.yahoo.config.FileReference;
import java.io.File;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class FileReferenceDownload {
    private final FileReference fileReference;
    private final CompletableFuture<Optional<File>> future;
    private final boolean downloadFromOtherSourceIfNotFound;
    private final String client;

    public FileReferenceDownload(FileReference fileReference, String client) {
        this(fileReference, client, true);
    }

    public FileReferenceDownload(FileReference fileReference, String client, boolean downloadFromOtherSourceIfNotFound) {
        this.fileReference = Objects.requireNonNull(fileReference, "file reference cannot be null");
        this.future = new CompletableFuture();
        this.downloadFromOtherSourceIfNotFound = downloadFromOtherSourceIfNotFound;
        this.client = client;
    }

    public FileReference fileReference() {
        return this.fileReference;
    }

    CompletableFuture<Optional<File>> future() {
        return this.future;
    }

    public boolean downloadFromOtherSourceIfNotFound() {
        return this.downloadFromOtherSourceIfNotFound;
    }

    public String client() {
        return this.client;
    }

    public String toString() {
        return this.fileReference + ", client: " + this.client;
    }
}

