/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.documentapi.messagebus.protocol;

import com.yahoo.document.Document;
import com.yahoo.document.serialization.DocumentDeserializer;
import com.yahoo.documentapi.messagebus.protocol.DocumentAcceptedReply;
import com.yahoo.documentapi.messagebus.protocol.LazyDecoder;
import com.yahoo.messagebus.Routable;
import java.nio.ByteBuffer;

public class GetDocumentReply
extends DocumentAcceptedReply {
    private Document document = null;
    private long lastModified = 0L;
    private DocumentDeserializer buffer = null;
    private LazyDecoder decoder = null;

    GetDocumentReply() {
        super(200003);
    }

    GetDocumentReply(LazyDecoder decoder, DocumentDeserializer buf) {
        super(200003);
        this.decoder = decoder;
        this.buffer = buf;
    }

    public GetDocumentReply(Document doc) {
        super(200003);
        this.document = doc;
    }

    private void deserialize() {
        if (this.decoder != null && this.buffer != null) {
            this.decoder.decode((Routable)this, this.buffer);
            this.decoder = null;
            this.buffer = null;
        }
    }

    public Document getDocument() {
        this.deserialize();
        return this.document;
    }

    public void setDocument(Document doc) {
        this.buffer = null;
        this.decoder = null;
        this.document = doc;
        this.lastModified = this.document != null && this.document.getLastModified() != null ? this.document.getLastModified() : 0L;
    }

    public long getLastModified() {
        this.deserialize();
        return this.lastModified;
    }

    void setLastModified(long modified) {
        this.lastModified = modified;
    }

    public ByteBuffer getSerializedBuffer() {
        return this.buffer != null ? this.buffer.getBuf().getByteBuffer() : null;
    }
}

