/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.documentapi.messagebus.protocol;

import com.yahoo.document.Document;
import com.yahoo.document.serialization.DocumentDeserializer;
import com.yahoo.document.serialization.DocumentReader;
import com.yahoo.vespa.objects.Serializer;

public class DocumentListEntry {
    private Document doc;
    private long timestamp;
    private boolean removeEntry;

    public DocumentListEntry(Document doc, long timestamp, boolean removeEntry) {
        this.doc = doc;
        this.timestamp = timestamp;
        this.removeEntry = removeEntry;
    }

    public void serialize(Serializer buf) {
        buf.putLong(null, this.timestamp);
        this.doc.serialize(buf);
        buf.putByte(null, (byte)(this.removeEntry ? 1 : 0));
    }

    public static int getApproxSize() {
        return 60;
    }

    public DocumentListEntry(DocumentDeserializer buf) {
        this.timestamp = buf.getLong(null);
        this.doc = new Document((DocumentReader)buf);
        this.removeEntry = buf.getByte(null) > 0;
    }

    public Document getDocument() {
        return this.doc;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public boolean isRemoveEntry() {
        return this.removeEntry;
    }
}

