/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.documentapi.messagebus.protocol;

import com.yahoo.documentapi.messagebus.protocol.AdaptiveLoadBalancer;
import com.yahoo.documentapi.messagebus.protocol.LoadBalancer;
import com.yahoo.documentapi.messagebus.protocol.SlobrokPolicy;
import com.yahoo.jrt.slobrok.api.Mirror;
import com.yahoo.messagebus.Reply;
import com.yahoo.messagebus.routing.Hop;
import com.yahoo.messagebus.routing.Route;
import com.yahoo.messagebus.routing.RoutingContext;
import com.yahoo.messagebus.routing.RoutingNodeIterator;
import java.util.List;
import java.util.Map;

public class LoadBalancerPolicy
extends SlobrokPolicy {
    private final String session;
    private final String pattern;
    private final LoadBalancer loadBalancer;

    LoadBalancerPolicy(String param) {
        this(LoadBalancerPolicy.parse(param));
    }

    private LoadBalancerPolicy(Map<String, String> params) {
        String cluster = params.get("cluster");
        this.session = params.get("session");
        if (cluster == null) {
            throw new IllegalArgumentException("Required parameter 'cluster' not set");
        }
        if (this.session == null) {
            throw new IllegalArgumentException("Required parameter 'session' not set");
        }
        this.pattern = cluster + "/*/" + this.session;
        this.loadBalancer = new AdaptiveLoadBalancer(cluster);
    }

    public void select(RoutingContext context) {
        LoadBalancer.Node node = this.getRecipient(context);
        if (node != null) {
            context.setContext((Object)node);
            Route route = new Route(context.getRoute());
            route.setHop(0, Hop.parse((String)(node.entry.getSpecString() + "/" + this.session)));
            context.addChild(route);
        } else {
            context.setError(100002, "Could not resolve any nodes to send to in pattern " + this.pattern);
        }
    }

    private LoadBalancer.Node getRecipient(RoutingContext context) {
        List<Mirror.Entry> lastLookup = this.lookup(context, this.pattern);
        return this.loadBalancer.getRecipient(lastLookup);
    }

    public void merge(RoutingContext context) {
        RoutingNodeIterator it = context.getChildIterator();
        Reply reply = it.removeReply();
        LoadBalancer.Node target = (LoadBalancer.Node)context.getContext();
        boolean busy = false;
        for (int i = 0; i < reply.getNumErrors(); ++i) {
            if (reply.getError(i).getCode() != 100005) continue;
            busy = true;
        }
        this.loadBalancer.received(target, busy);
        context.setReply(reply);
    }

    public void destroy() {
    }

    LoadBalancer getLoadBalancer() {
        return this.loadBalancer;
    }
}

