/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.documentapi.messagebus;

import com.yahoo.document.Document;
import com.yahoo.document.DocumentId;
import com.yahoo.document.DocumentPut;
import com.yahoo.document.DocumentUpdate;
import com.yahoo.documentapi.AsyncParameters;
import com.yahoo.documentapi.AsyncSession;
import com.yahoo.documentapi.DocumentIdResponse;
import com.yahoo.documentapi.DocumentOperationParameters;
import com.yahoo.documentapi.DocumentResponse;
import com.yahoo.documentapi.DocumentUpdateResponse;
import com.yahoo.documentapi.RemoveResponse;
import com.yahoo.documentapi.Response;
import com.yahoo.documentapi.ResponseHandler;
import com.yahoo.documentapi.Result;
import com.yahoo.documentapi.UpdateResponse;
import com.yahoo.documentapi.messagebus.MessageBusParams;
import com.yahoo.documentapi.messagebus.MessageBusSession;
import com.yahoo.documentapi.messagebus.protocol.DocumentProtocol;
import com.yahoo.documentapi.messagebus.protocol.GetDocumentMessage;
import com.yahoo.documentapi.messagebus.protocol.GetDocumentReply;
import com.yahoo.documentapi.messagebus.protocol.PutDocumentMessage;
import com.yahoo.documentapi.messagebus.protocol.RemoveDocumentMessage;
import com.yahoo.documentapi.messagebus.protocol.RemoveDocumentReply;
import com.yahoo.documentapi.messagebus.protocol.UpdateDocumentMessage;
import com.yahoo.documentapi.messagebus.protocol.UpdateDocumentReply;
import com.yahoo.messagebus.Message;
import com.yahoo.messagebus.MessageBus;
import com.yahoo.messagebus.Reply;
import com.yahoo.messagebus.ReplyHandler;
import com.yahoo.messagebus.SourceSession;
import com.yahoo.messagebus.StaticThrottlePolicy;
import com.yahoo.messagebus.ThrottlePolicy;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MessageBusAsyncSession
implements MessageBusSession,
AsyncSession {
    private static final Logger log = Logger.getLogger(MessageBusAsyncSession.class.getName());
    private final AtomicLong requestId = new AtomicLong(0L);
    private final BlockingQueue<Response> responses = new LinkedBlockingQueue<Response>();
    private final ThrottlePolicy throttlePolicy;
    private final SourceSession session;
    private String route;
    private String routeForGet;
    private int traceLevel;

    MessageBusAsyncSession(AsyncParameters asyncParams, MessageBus bus, MessageBusParams mbusParams) {
        this(asyncParams, bus, mbusParams, null);
    }

    MessageBusAsyncSession(AsyncParameters asyncParams, MessageBus bus, MessageBusParams mbusParams, ReplyHandler handler) {
        this.route = mbusParams.getRoute();
        this.routeForGet = mbusParams.getRouteForGet();
        this.traceLevel = mbusParams.getTraceLevel();
        this.throttlePolicy = mbusParams.getSourceSessionParams().getThrottlePolicy();
        if (handler == null) {
            handler = new MyReplyHandler(asyncParams.getResponseHandler(), this.responses);
        }
        this.session = bus.createSourceSession(handler, mbusParams.getSourceSessionParams());
    }

    @Override
    public Result put(Document document) {
        return this.put(new DocumentPut(document), DocumentOperationParameters.parameters());
    }

    @Override
    public Result put(DocumentPut documentPut, DocumentProtocol.Priority pri) {
        return this.put(documentPut, DocumentOperationParameters.parameters().withPriority(pri));
    }

    @Override
    public Result put(DocumentPut documentPut, DocumentOperationParameters parameters) {
        PutDocumentMessage msg = new PutDocumentMessage(documentPut);
        msg.setPriority(parameters.priority().orElse(DocumentProtocol.Priority.NORMAL_3));
        return this.send(msg, parameters);
    }

    @Override
    public Result get(DocumentId id) {
        return this.get(id, DocumentOperationParameters.parameters());
    }

    @Override
    @Deprecated
    public Result get(DocumentId id, boolean headersOnly, DocumentProtocol.Priority pri) {
        return this.get(id, pri);
    }

    @Override
    public Result get(DocumentId id, DocumentProtocol.Priority pri) {
        return this.get(id, DocumentOperationParameters.parameters().withPriority(pri));
    }

    @Override
    public Result get(DocumentId id, DocumentOperationParameters parameters) {
        GetDocumentMessage msg = new GetDocumentMessage(id, parameters.fieldSet().orElse("[all]"));
        msg.setPriority(parameters.priority().orElse(DocumentProtocol.Priority.NORMAL_1));
        return this.send(msg, parameters);
    }

    @Override
    public Result remove(DocumentId id) {
        return this.remove(id, DocumentOperationParameters.parameters());
    }

    @Override
    public Result remove(DocumentId id, DocumentProtocol.Priority pri) {
        return this.remove(id, DocumentOperationParameters.parameters().withPriority(pri));
    }

    @Override
    public Result remove(DocumentId id, DocumentOperationParameters parameters) {
        RemoveDocumentMessage msg = new RemoveDocumentMessage(id);
        msg.setPriority(parameters.priority().orElse(DocumentProtocol.Priority.NORMAL_2));
        return this.send(msg, parameters);
    }

    @Override
    public Result update(DocumentUpdate update) {
        return this.update(update, DocumentOperationParameters.parameters());
    }

    @Override
    public Result update(DocumentUpdate update, DocumentProtocol.Priority pri) {
        return this.update(update, DocumentOperationParameters.parameters().withPriority(pri));
    }

    @Override
    public Result update(DocumentUpdate update, DocumentOperationParameters parameters) {
        UpdateDocumentMessage msg = new UpdateDocumentMessage(update);
        msg.setPriority(parameters.priority().orElse(DocumentProtocol.Priority.NORMAL_2));
        return this.send(msg, parameters);
    }

    private boolean mayOverrideWithGetOnlyRoute(Message msg) {
        return msg.getType() == 100003 && ("default".equals(this.route) || "route:default".equals(this.route));
    }

    Result send(Message msg, DocumentOperationParameters parameters) {
        try {
            long reqId = this.requestId.incrementAndGet();
            msg.setContext((Object)reqId);
            msg.getTrace().setLevel(parameters.traceLevel().orElse(this.traceLevel));
            String toRoute = parameters.route().orElse(this.mayOverrideWithGetOnlyRoute(msg) ? this.routeForGet : this.route);
            if (toRoute != null) {
                return MessageBusAsyncSession.toResult(reqId, this.session.send(msg, toRoute, true));
            }
            return MessageBusAsyncSession.toResult(reqId, this.session.send(msg));
        }
        catch (Exception e) {
            return new Result(Result.ResultType.FATAL_ERROR, new Error(e.getMessage(), e));
        }
    }

    public Result send(Message msg) {
        return this.send(msg, null);
    }

    @Override
    public Response getNext() {
        return (Response)this.responses.poll();
    }

    @Override
    public Response getNext(int timeoutMilliseconds) throws InterruptedException {
        return this.responses.poll(timeoutMilliseconds, TimeUnit.MILLISECONDS);
    }

    @Override
    public void destroy() {
        this.session.destroy();
    }

    @Override
    public String getRoute() {
        return this.route;
    }

    @Override
    public void setRoute(String route) {
        this.route = route;
    }

    @Override
    public int getTraceLevel() {
        return this.traceLevel;
    }

    @Override
    public void setTraceLevel(int traceLevel) {
        this.traceLevel = traceLevel;
    }

    @Override
    public double getCurrentWindowSize() {
        if (this.throttlePolicy instanceof StaticThrottlePolicy) {
            return ((StaticThrottlePolicy)this.throttlePolicy).getMaxPendingCount();
        }
        return 0.0;
    }

    static String getErrorMessage(Reply reply) {
        if (!reply.hasErrors()) {
            return null;
        }
        StringBuilder errors = new StringBuilder();
        for (int i = 0; i < reply.getNumErrors(); ++i) {
            errors.append(reply.getError(i)).append(" ");
        }
        return errors.toString();
    }

    private static Result.ResultType messageBusErrorToResultType(int messageBusError) {
        switch (messageBusError) {
            case 100001: {
                return Result.ResultType.TRANSIENT_ERROR;
            }
        }
        return Result.ResultType.FATAL_ERROR;
    }

    private static Result toResult(long reqId, com.yahoo.messagebus.Result mbusResult) {
        if (mbusResult.isAccepted()) {
            return new Result(reqId);
        }
        return new Result(MessageBusAsyncSession.messageBusErrorToResultType(mbusResult.getError().getCode()), new Error(mbusResult.getError().getMessage() + " (" + mbusResult.getError().getCode() + ")"));
    }

    private static Response toResponse(Reply reply) {
        long reqId = (Long)reply.getContext();
        return reply.hasErrors() ? MessageBusAsyncSession.toError(reply, reqId) : MessageBusAsyncSession.toSuccess(reply, reqId);
    }

    private static Response toError(Reply reply, long reqId) {
        boolean definitelyNotFound = reply instanceof UpdateDocumentReply && !((UpdateDocumentReply)reply).wasFound() || reply instanceof RemoveDocumentReply && !((RemoveDocumentReply)reply).wasFound();
        boolean conditionFailed = reply.getErrorCodes().contains(251013);
        Response.Outcome outcome = definitelyNotFound ? Response.Outcome.NOT_FOUND : (conditionFailed ? Response.Outcome.CONDITION_FAILED : Response.Outcome.ERROR);
        Message msg = reply.getMessage();
        String err = MessageBusAsyncSession.getErrorMessage(reply);
        switch (msg.getType()) {
            case 100004: {
                return new DocumentResponse(reqId, ((PutDocumentMessage)msg).getDocumentPut().getDocument(), err, outcome, reply.getTrace());
            }
            case 100006: {
                return new DocumentUpdateResponse(reqId, ((UpdateDocumentMessage)msg).getDocumentUpdate(), err, outcome, reply.getTrace());
            }
            case 100005: {
                return new DocumentIdResponse(reqId, ((RemoveDocumentMessage)msg).getDocumentId(), err, outcome, reply.getTrace());
            }
            case 100003: {
                return new DocumentIdResponse(reqId, ((GetDocumentMessage)msg).getDocumentId(), err, outcome, reply.getTrace());
            }
        }
        return new Response(reqId, err, outcome, reply.getTrace());
    }

    private static Response toSuccess(Reply reply, long reqId) {
        switch (reply.getType()) {
            case 200003: {
                GetDocumentReply docReply = (GetDocumentReply)reply;
                Document getDoc = docReply.getDocument();
                if (getDoc != null) {
                    getDoc.setLastModified(Long.valueOf(docReply.getLastModified()));
                }
                return new DocumentResponse(reqId, getDoc, reply.getTrace());
            }
            case 200005: {
                return new RemoveResponse(reqId, ((RemoveDocumentReply)reply).wasFound(), reply.getTrace());
            }
            case 200006: {
                return new UpdateResponse(reqId, ((UpdateDocumentReply)reply).wasFound(), reply.getTrace());
            }
            case 200004: {
                return new DocumentResponse(reqId, ((PutDocumentMessage)reply.getMessage()).getDocumentPut().getDocument(), reply.getTrace());
            }
        }
        return new Response(reqId, null, Response.Outcome.SUCCESS, reply.getTrace());
    }

    private static class MyReplyHandler
    implements ReplyHandler {
        final ResponseHandler handler;
        final Queue<Response> queue;

        MyReplyHandler(ResponseHandler handler, Queue<Response> queue) {
            this.handler = handler;
            this.queue = queue;
        }

        public void handleReply(Reply reply) {
            if (reply.getTrace().getLevel() > 0) {
                log.log(Level.INFO, reply.getTrace().toString());
            }
            Response response = MessageBusAsyncSession.toResponse(reply);
            if (this.handler != null) {
                this.handler.handleResponse(response);
            } else {
                this.queue.add(response);
            }
        }
    }
}

