/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.documentapi;

import com.yahoo.messagebus.Trace;
import java.util.Objects;

public class Response {
    private final long requestId;
    private final String textMessage;
    private final Outcome outcome;
    private final Trace trace;

    public Response(long requestId) {
        this(requestId, null);
    }

    public Response(long requestId, String textMessage) {
        this(requestId, textMessage, Outcome.SUCCESS);
    }

    @Deprecated(since="7")
    public Response(long requestId, String textMessage, boolean success) {
        this(requestId, textMessage, success ? Outcome.SUCCESS : Outcome.ERROR);
    }

    public Response(long requestId, String textMessage, Outcome outcome) {
        this(requestId, textMessage, outcome, null);
    }

    public Response(long requestId, String textMessage, Outcome outcome, Trace trace) {
        this.requestId = requestId;
        this.textMessage = textMessage;
        this.outcome = outcome;
        this.trace = trace;
    }

    public String getTextMessage() {
        return this.textMessage;
    }

    public boolean isSuccess() {
        return this.outcome == Outcome.SUCCESS;
    }

    public Outcome outcome() {
        return this.outcome;
    }

    public long getRequestId() {
        return this.requestId;
    }

    public Trace getTrace() {
        return this.trace;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Response)) {
            return false;
        }
        Response response = (Response)o;
        return this.requestId == response.requestId && Objects.equals(this.textMessage, response.textMessage) && this.outcome == response.outcome;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.requestId, this.textMessage, this.outcome});
    }

    public String toString() {
        return "Response " + this.requestId + (this.textMessage == null ? "" : this.textMessage) + " " + this.outcome;
    }

    public static enum Outcome {
        SUCCESS,
        CONDITION_FAILED,
        NOT_FOUND,
        ERROR;

    }
}

