/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.documentapi.messagebus.protocol;

import com.yahoo.document.BucketId;
import com.yahoo.document.FixedBucketSpaces;
import com.yahoo.documentapi.messagebus.protocol.CreateVisitorReply;
import com.yahoo.documentapi.messagebus.protocol.DocumentMessage;
import com.yahoo.documentapi.messagebus.protocol.DocumentReply;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class CreateVisitorMessage
extends DocumentMessage {
    private String libName = "DumpVisitor";
    private String instanceId = "";
    private String controlDestination = "";
    private String dataDestination = "";
    private String docSelection = "";
    private String bucketSpace = FixedBucketSpaces.defaultSpace();
    private int maxPendingReplyCount = 8;
    private List<BucketId> buckets = new ArrayList<BucketId>();
    private long fromTime = 0L;
    private long toTime = 0L;
    private boolean visitRemoves = false;
    private String fieldSet = "[all]";
    private boolean visitInconsistentBuckets = false;
    private Map<String, byte[]> params = new TreeMap<String, byte[]>();
    private int version = 42;
    private int ordering = 0;
    private int maxBucketsPerVisitor = 1;

    CreateVisitorMessage() {
    }

    public CreateVisitorMessage(String libraryName, String instanceId, String controlDestination, String dataDestination) {
        this.libName = libraryName;
        this.instanceId = instanceId;
        this.controlDestination = controlDestination;
        this.dataDestination = dataDestination;
    }

    public String getLibraryName() {
        return this.libName;
    }

    public void setLibraryName(String libraryName) {
        this.libName = libraryName;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public String getControlDestination() {
        return this.controlDestination;
    }

    public void setControlDestination(String controlDestination) {
        this.controlDestination = controlDestination;
    }

    public String getDataDestination() {
        return this.dataDestination;
    }

    public void setDataDestination(String dataDestination) {
        this.dataDestination = dataDestination;
    }

    public String getDocumentSelection() {
        return this.docSelection;
    }

    public void setDocumentSelection(String documentSelection) {
        this.docSelection = documentSelection;
    }

    public String getBucketSpace() {
        return this.bucketSpace;
    }

    public void setBucketSpace(String bucketSpace) {
        this.bucketSpace = bucketSpace;
    }

    public int getMaxPendingReplyCount() {
        return this.maxPendingReplyCount;
    }

    public void setMaxPendingReplyCount(int count) {
        this.maxPendingReplyCount = count;
    }

    public Map<String, byte[]> getParameters() {
        return this.params;
    }

    public void setParameters(Map<String, byte[]> parameters) {
        this.params = parameters;
    }

    public List<BucketId> getBuckets() {
        return this.buckets;
    }

    public void setBuckets(List<BucketId> buckets) {
        this.buckets = buckets;
    }

    public boolean getVisitRemoves() {
        return this.visitRemoves;
    }

    public void setVisitRemoves(boolean visitRemoves) {
        this.visitRemoves = visitRemoves;
    }

    public String getFieldSet() {
        return this.fieldSet;
    }

    public void setFieldSet(String fieldSet) {
        this.fieldSet = fieldSet;
    }

    public boolean getVisitInconsistentBuckets() {
        return this.visitInconsistentBuckets;
    }

    public void setVisitInconsistentBuckets(boolean visitInconsistentBuckets) {
        this.visitInconsistentBuckets = visitInconsistentBuckets;
    }

    public void setFromTimestamp(long from) {
        this.fromTime = from;
    }

    public void setToTimestamp(long to) {
        this.toTime = to;
    }

    public long getFromTimestamp() {
        return this.fromTime;
    }

    public long getToTimestamp() {
        return this.toTime;
    }

    public void setVisitorDispatcherVersion(int version) {
        this.version = version;
    }

    public int getVisitorDispatcherVersion() {
        return this.version;
    }

    public void setVisitorOrdering(int ordering) {
        this.ordering = ordering;
    }

    public int getVisitorOrdering() {
        return this.ordering;
    }

    public void setMaxBucketsPerVisitor(int max) {
        this.maxBucketsPerVisitor = max;
    }

    public int getMaxBucketsPerVisitor() {
        return this.maxBucketsPerVisitor;
    }

    @Override
    public DocumentReply createReply() {
        return new CreateVisitorReply(200007);
    }

    @Override
    public int getApproxSize() {
        return this.buckets.size() * 8;
    }

    public int getType() {
        return 100007;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append("CreateVisitorMessage(");
        if (this.buckets.size() == 0) {
            sb.append("No buckets");
        } else if (this.buckets.size() == 1) {
            sb.append("Bucket ").append(this.buckets.iterator().next().toString());
        } else if (this.buckets.size() < 65536) {
            sb.append(this.buckets.size()).append(" buckets:");
            Iterator<BucketId> it = this.buckets.iterator();
            for (int i = 0; it.hasNext() && i < 3; ++i) {
                sb.append(' ').append(it.next().toString());
            }
            if (it.hasNext()) {
                sb.append(" ...");
            }
        } else {
            sb.append("All buckets");
        }
        if (this.fromTime != 0L || this.toTime != 0L) {
            sb.append(", time ").append(this.fromTime).append('-').append(this.toTime);
        }
        sb.append(", selection '").append(this.docSelection).append('\'');
        sb.append(", bucket space '").append(this.bucketSpace).append('\'');
        if (!this.libName.equals("DumpVisitor")) {
            sb.append(", library ").append(this.libName);
        }
        if (this.visitRemoves) {
            sb.append(", including removes");
        }
        sb.append(", get fields: " + this.fieldSet);
        if (this.visitInconsistentBuckets) {
            sb.append(", visit inconsistent buckets");
        }
        return sb.append(')').toString();
    }
}

