/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.documentapi.messagebus.protocol;

import com.yahoo.document.BucketId;
import com.yahoo.document.BucketIdFactory;
import com.yahoo.document.DocumentId;
import com.yahoo.document.DocumentUpdate;
import com.yahoo.document.idstring.GroupDocIdString;
import com.yahoo.document.idstring.IdString;
import com.yahoo.document.idstring.UserDocIdString;
import com.yahoo.document.serialization.DocumentDeserializer;
import com.yahoo.documentapi.messagebus.protocol.BatchDocumentUpdateReply;
import com.yahoo.documentapi.messagebus.protocol.DocumentMessage;
import com.yahoo.documentapi.messagebus.protocol.DocumentReply;
import com.yahoo.documentapi.messagebus.protocol.LazyDecoder;
import com.yahoo.messagebus.Routable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class BatchDocumentUpdateMessage
extends DocumentMessage {
    private DocumentDeserializer buffer = null;
    private List<DocumentUpdate> updates = new ArrayList<DocumentUpdate>();
    private LazyDecoder decoder = null;
    private String group = null;
    private Long userId = null;
    private BucketId bucketId = null;

    public String getGroup() {
        return this.group;
    }

    public Long getUserId() {
        return this.userId;
    }

    BatchDocumentUpdateMessage() {
    }

    public BatchDocumentUpdateMessage(long userId, LazyDecoder decoder, DocumentDeserializer buffer) {
        this.userId = userId;
        this.decoder = decoder;
        this.buffer = buffer;
        this.setBucketId((IdString)new UserDocIdString("foo", userId, "bar"));
    }

    public BatchDocumentUpdateMessage(String group, LazyDecoder decoder, DocumentDeserializer buffer) {
        this.group = group;
        this.decoder = decoder;
        this.buffer = buffer;
        this.setBucketId((IdString)new GroupDocIdString("foo", group, "bar"));
    }

    public BatchDocumentUpdateMessage(long userId) {
        this.userId = userId;
        this.setBucketId((IdString)new UserDocIdString("foo", userId, "bar"));
    }

    public BatchDocumentUpdateMessage(String group) {
        this.group = group;
        this.setBucketId((IdString)new GroupDocIdString("foo", group, "bar"));
    }

    void setBucketId(IdString id) {
        BucketIdFactory factory = new BucketIdFactory();
        this.bucketId = factory.getBucketId(new DocumentId(id));
    }

    BucketId getBucketId() {
        return this.bucketId;
    }

    private void deserialize() {
        if (this.decoder != null && this.buffer != null) {
            this.decoder.decode((Routable)this, this.buffer);
            this.decoder = null;
            this.buffer = null;
        }
    }

    public List<DocumentUpdate> getUpdates() {
        this.deserialize();
        return this.updates;
    }

    public void addUpdate(DocumentUpdate upd) {
        this.buffer = null;
        this.decoder = null;
        this.verifyUpdate(upd);
        this.updates.add(upd);
    }

    ByteBuffer getSerializedBuffer() {
        return this.buffer != null ? this.buffer.getBuf().getByteBuffer() : null;
    }

    @Override
    public DocumentReply createReply() {
        return new BatchDocumentUpdateReply();
    }

    public int getType() {
        return 100026;
    }

    void verifyUpdate(DocumentUpdate update) {
        if (update == null) {
            throw new IllegalArgumentException("Document update can not be null.");
        }
        IdString idString = update.getId().getScheme();
        if (this.group != null) {
            if (!idString.hasGroup()) {
                throw new IllegalArgumentException("Batch update message can only contain groupdoc or orderdoc items");
            }
            String idGroup = idString.getGroup();
            if (!this.group.equals(idGroup)) {
                throw new IllegalArgumentException("Batch update message can not contain messages from group " + idGroup + " only group " + this.group);
            }
        } else {
            long foundUserId = 0L;
            if (!idString.hasNumber()) {
                throw new IllegalArgumentException("Batch update message can only contain userdoc or orderdoc items");
            }
            foundUserId = idString.getNumber();
            if (this.userId != foundUserId) {
                throw new IllegalArgumentException("Batch update message can not contain messages from user " + foundUserId + " only user " + this.userId);
            }
        }
    }
}

