/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.documentapi.messagebus.protocol;

import com.yahoo.document.BucketId;
import com.yahoo.document.DocumentId;
import com.yahoo.document.FixedBucketSpaces;
import com.yahoo.document.serialization.DocumentDeserializer;
import com.yahoo.document.serialization.DocumentSerializer;
import com.yahoo.documentapi.messagebus.protocol.CreateVisitorMessage;
import com.yahoo.documentapi.messagebus.protocol.DocumentIgnoredReply;
import com.yahoo.documentapi.messagebus.protocol.DocumentMessage;
import com.yahoo.documentapi.messagebus.protocol.DocumentReply;
import com.yahoo.documentapi.messagebus.protocol.GetDocumentMessage;
import com.yahoo.documentapi.messagebus.protocol.RoutableFactories50;
import com.yahoo.vespa.objects.Deserializer;
import com.yahoo.vespa.objects.Serializer;
import java.util.Map;

public abstract class RoutableFactories51
extends RoutableFactories50 {

    public static class DocumentIgnoredReplyFactory
    extends RoutableFactories50.DocumentReplyFactory {
        @Override
        protected DocumentReply doDecode(DocumentDeserializer buf) {
            return new DocumentIgnoredReply();
        }

        @Override
        protected boolean doEncode(DocumentReply obj, DocumentSerializer buf) {
            return true;
        }
    }

    public static class GetDocumentMessageFactory
    extends RoutableFactories50.DocumentMessageFactory {
        @Override
        protected DocumentMessage doDecode(DocumentDeserializer buf) {
            return new GetDocumentMessage(new DocumentId((Deserializer)buf), GetDocumentMessageFactory.decodeString((Deserializer)buf));
        }

        @Override
        protected boolean doEncode(DocumentMessage obj, DocumentSerializer buf) {
            GetDocumentMessage msg = (GetDocumentMessage)obj;
            msg.getDocumentId().serialize((Serializer)buf);
            GetDocumentMessageFactory.encodeString(msg.getFieldSet(), (Serializer)buf);
            return true;
        }
    }

    public static class CreateVisitorMessageFactory
    extends RoutableFactories50.DocumentMessageFactory {
        protected String decodeBucketSpace(Deserializer deserializer) {
            return FixedBucketSpaces.defaultSpace();
        }

        @Override
        protected DocumentMessage doDecode(DocumentDeserializer buf) {
            int i;
            CreateVisitorMessage msg = new CreateVisitorMessage();
            msg.setLibraryName(CreateVisitorMessageFactory.decodeString((Deserializer)buf));
            msg.setInstanceId(CreateVisitorMessageFactory.decodeString((Deserializer)buf));
            msg.setControlDestination(CreateVisitorMessageFactory.decodeString((Deserializer)buf));
            msg.setDataDestination(CreateVisitorMessageFactory.decodeString((Deserializer)buf));
            msg.setDocumentSelection(CreateVisitorMessageFactory.decodeString((Deserializer)buf));
            msg.setMaxPendingReplyCount(buf.getInt(null));
            int size = buf.getInt(null);
            for (i = 0; i < size; ++i) {
                long reversed = buf.getLong(null);
                long rawid = reversed >>> 56 & 0xFFL | reversed >>> 40 & 0xFF00L | reversed >>> 24 & 0xFF0000L | reversed >>> 8 & 0xFF000000L | reversed << 8 & 0xFF00000000L | reversed << 24 & 0xFF0000000000L | reversed << 40 & 0xFF000000000000L | reversed << 56 & 0xFF00000000000000L;
                msg.getBuckets().add(new BucketId(rawid));
            }
            msg.setFromTimestamp(buf.getLong(null));
            msg.setToTimestamp(buf.getLong(null));
            msg.setVisitRemoves(buf.getByte(null) == 1);
            msg.setFieldSet(CreateVisitorMessageFactory.decodeString((Deserializer)buf));
            msg.setVisitInconsistentBuckets(buf.getByte(null) == 1);
            size = buf.getInt(null);
            for (i = 0; i < size; ++i) {
                String key = CreateVisitorMessageFactory.decodeString((Deserializer)buf);
                int sz = buf.getInt(null);
                msg.getParameters().put(key, buf.getBytes(null, sz));
            }
            msg.setVisitorOrdering(buf.getInt(null));
            msg.setMaxBucketsPerVisitor(buf.getInt(null));
            msg.setVisitorDispatcherVersion(50);
            msg.setBucketSpace(this.decodeBucketSpace((Deserializer)buf));
            return msg;
        }

        protected boolean encodeBucketSpace(String bucketSpace, DocumentSerializer buf) {
            return FixedBucketSpaces.defaultSpace().equals(bucketSpace);
        }

        @Override
        protected boolean doEncode(DocumentMessage obj, DocumentSerializer buf) {
            CreateVisitorMessage msg = (CreateVisitorMessage)obj;
            CreateVisitorMessageFactory.encodeString(msg.getLibraryName(), (Serializer)buf);
            CreateVisitorMessageFactory.encodeString(msg.getInstanceId(), (Serializer)buf);
            CreateVisitorMessageFactory.encodeString(msg.getControlDestination(), (Serializer)buf);
            CreateVisitorMessageFactory.encodeString(msg.getDataDestination(), (Serializer)buf);
            CreateVisitorMessageFactory.encodeString(msg.getDocumentSelection(), (Serializer)buf);
            buf.putInt(null, msg.getMaxPendingReplyCount());
            buf.putInt(null, msg.getBuckets().size());
            for (BucketId bucketId : msg.getBuckets()) {
                long rawid = bucketId.getRawId();
                long reversed = rawid >>> 56 & 0xFFL | rawid >>> 40 & 0xFF00L | rawid >>> 24 & 0xFF0000L | rawid >>> 8 & 0xFF000000L | rawid << 8 & 0xFF00000000L | rawid << 24 & 0xFF0000000000L | rawid << 40 & 0xFF000000000000L | rawid << 56 & 0xFF00000000000000L;
                buf.putLong(null, reversed);
            }
            buf.putLong(null, msg.getFromTimestamp());
            buf.putLong(null, msg.getToTimestamp());
            buf.putByte(null, msg.getVisitRemoves() ? (byte)1 : 0);
            CreateVisitorMessageFactory.encodeString(msg.getFieldSet(), (Serializer)buf);
            buf.putByte(null, msg.getVisitInconsistentBuckets() ? (byte)1 : 0);
            buf.putInt(null, msg.getParameters().size());
            for (Map.Entry entry : msg.getParameters().entrySet()) {
                CreateVisitorMessageFactory.encodeString((String)entry.getKey(), (Serializer)buf);
                byte[] b = (byte[])entry.getValue();
                buf.putInt(null, b.length);
                buf.put(null, b);
            }
            buf.putInt(null, msg.getVisitorOrdering());
            buf.putInt(null, msg.getMaxBucketsPerVisitor());
            return this.encodeBucketSpace(msg.getBucketSpace(), buf);
        }
    }
}

