/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.documentapi.messagebus.protocol;

import com.yahoo.cloud.config.SlobroksConfig;
import com.yahoo.config.subscription.ConfigSource;
import com.yahoo.config.subscription.ConfigSourceSet;
import com.yahoo.config.subscription.ConfigSubscriber;
import com.yahoo.documentapi.messagebus.protocol.AsyncInitializationPolicy;
import com.yahoo.jrt.Supervisor;
import com.yahoo.jrt.Transport;
import com.yahoo.jrt.slobrok.api.IMirror;
import com.yahoo.jrt.slobrok.api.Mirror;
import com.yahoo.jrt.slobrok.api.SlobrokList;
import com.yahoo.messagebus.routing.RoutingContext;
import java.util.Map;

public abstract class ExternalSlobrokPolicy
extends AsyncInitializationPolicy
implements ConfigSubscriber.SingleSubscriber<SlobroksConfig> {
    String error;
    Supervisor orb = null;
    Mirror mirror = null;
    SlobrokList slobroks = null;
    boolean firstTry = true;
    private ConfigSubscriber subscriber;
    String[] configSources = null;
    String slobrokConfigId = "admin/slobrok.0";

    public ExternalSlobrokPolicy(Map<String, String> param) {
        super(param);
        String slbrk;
        String conf = param.get("config");
        if (conf != null) {
            this.configSources = conf.split(",");
        }
        if ((slbrk = param.get("slobroks")) != null) {
            this.slobroks = new SlobrokList();
            this.slobroks.setup(slbrk.split(","));
        }
        if (this.slobroks != null || this.configSources != null) {
            this.needAsynchronousInitialization();
        }
    }

    @Override
    public void init() {
        if (this.slobroks != null) {
            this.orb = new Supervisor(new Transport());
            this.mirror = new Mirror(this.orb, this.slobroks);
        }
        if (this.configSources != null && this.mirror == null) {
            this.orb = new Supervisor(new Transport());
            this.subscriber = this.subscribe(this.slobrokConfigId, new ConfigSourceSet(this.configSources));
        }
    }

    private ConfigSubscriber subscribe(String configId, ConfigSourceSet configSourceSet) {
        ConfigSubscriber subscriber = new ConfigSubscriber((ConfigSource)configSourceSet);
        subscriber.subscribe((ConfigSubscriber.SingleSubscriber)this, SlobroksConfig.class, configId);
        return subscriber;
    }

    public IMirror getMirror() {
        return this.mirror;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Mirror.Entry[] lookup(RoutingContext context, String pattern) {
        Object mirror1 = this.mirror != null ? this.mirror : context.getMirror();
        Mirror.Entry[] arr = mirror1.lookup(pattern);
        if (arr.length == 0 && this.firstTry) {
            ExternalSlobrokPolicy externalSlobrokPolicy = this;
            synchronized (externalSlobrokPolicy) {
                try {
                    for (int count = 0; arr.length == 0 && count < 100; ++count) {
                        Thread.sleep(50L);
                        arr = mirror1.lookup(pattern);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        this.firstTry = false;
        return arr;
    }

    public synchronized void configure(SlobroksConfig config) {
        String[] slist = new String[config.slobrok().size()];
        for (int i = 0; i < config.slobrok().size(); ++i) {
            slist[i] = config.slobrok(i).connectionspec();
        }
        if (this.slobroks == null) {
            this.slobroks = new SlobrokList();
        }
        this.slobroks.setup(slist);
        if (this.mirror == null) {
            this.mirror = new Mirror(this.orb, this.slobroks);
        }
    }

    @Override
    public void destroy() {
        if (this.subscriber != null) {
            this.subscriber.close();
        }
    }
}

