/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonFactoryBuilder;
import com.yahoo.document.DocumentOperation;
import com.yahoo.document.DocumentPut;
import com.yahoo.document.DocumentRemove;
import com.yahoo.document.DocumentTypeManager;
import com.yahoo.document.DocumentUpdate;
import com.yahoo.document.json.JsonReader;
import com.yahoo.vespaxmlparser.DocumentFeedOperation;
import com.yahoo.vespaxmlparser.DocumentUpdateFeedOperation;
import com.yahoo.vespaxmlparser.FeedOperation;
import com.yahoo.vespaxmlparser.FeedReader;
import com.yahoo.vespaxmlparser.RemoveFeedOperation;
import java.io.InputStream;

public class JsonFeedReader
implements FeedReader {
    private final JsonReader reader;
    private InputStream stream;
    private static final JsonFactory jsonFactory = ((JsonFactoryBuilder)new JsonFactoryBuilder().disable(JsonFactory.Feature.CANONICALIZE_FIELD_NAMES)).build();

    public JsonFeedReader(InputStream stream, DocumentTypeManager docMan) {
        this.reader = new JsonReader(docMan, stream, jsonFactory);
        this.stream = stream;
    }

    @Override
    public FeedOperation read() throws Exception {
        DocumentOperation documentOperation = this.reader.next();
        if (documentOperation == null) {
            this.stream.close();
            return FeedOperation.INVALID;
        }
        if (documentOperation instanceof DocumentUpdate) {
            return new DocumentUpdateFeedOperation((DocumentUpdate)documentOperation, documentOperation.getCondition());
        }
        if (documentOperation instanceof DocumentRemove) {
            return new RemoveFeedOperation(documentOperation.getId(), documentOperation.getCondition());
        }
        if (documentOperation instanceof DocumentPut) {
            return new DocumentFeedOperation(((DocumentPut)documentOperation).getDocument(), documentOperation.getCondition());
        }
        throw new IllegalArgumentException("Got unknown class from JSON reader: " + documentOperation.getClass().getName());
    }
}

