/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.annotation;

import com.yahoo.document.annotation.AlternateSpanList;
import com.yahoo.document.annotation.DummySpanNode;
import com.yahoo.document.annotation.InvalidatingIterator;
import com.yahoo.document.annotation.RecursiveNodeIterator;
import com.yahoo.document.annotation.Span;
import com.yahoo.document.annotation.SpanNode;
import com.yahoo.document.serialization.SpanNodeReader;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

@Deprecated(forRemoval=true)
public class SpanList
extends SpanNode {
    public static final byte ID = 2;
    private final List<SpanNode> children;
    private int cachedFrom = Integer.MIN_VALUE;
    private int cachedTo = Integer.MIN_VALUE;

    public SpanList() {
        this.children = new LinkedList<SpanNode>();
    }

    public SpanList(SpanNodeReader reader) {
        this();
        reader.read(this);
    }

    protected SpanList(List<SpanNode> children) {
        this.children = children;
    }

    public SpanList(SpanList other) {
        this.children = new LinkedList<SpanNode>();
        for (SpanNode otherNode : other.children) {
            if (otherNode instanceof Span) {
                this.children.add(new Span((Span)otherNode));
                continue;
            }
            if (otherNode instanceof AlternateSpanList) {
                this.children.add(new AlternateSpanList((AlternateSpanList)otherNode));
                continue;
            }
            if (otherNode instanceof SpanList) {
                this.children.add(new SpanList((SpanList)otherNode));
                continue;
            }
            if (otherNode instanceof DummySpanNode) {
                this.children.add(otherNode);
                continue;
            }
            throw new IllegalStateException("Cannot create copy of " + String.valueOf(otherNode) + " with class " + String.valueOf(otherNode == null ? "null" : otherNode.getClass()));
        }
    }

    void checkValidity(SpanNode node, List<SpanNode> childrenToCheck) {
        if (!node.isValid()) {
            throw new IllegalStateException("Cannot reuse SpanNode instance " + String.valueOf(node) + ", is INVALID.");
        }
        if (node.getParent() != null) {
            if (node.getParent() != this) {
                throw new IllegalStateException(String.valueOf(node) + " is already a child of " + String.valueOf(node.getParent()) + ", cannot be added to " + String.valueOf(this));
            }
            if (node.getParent() == this && childrenToCheck.contains(node)) {
                throw new IllegalStateException(String.valueOf(node) + " is already a child of " + String.valueOf(this) + ", cannot be added twice to the same parent node.");
            }
        }
    }

    public SpanList add(SpanNode node) {
        this.checkValidity(node, this.children());
        node.setParent(this);
        this.resetCachedFromAndTo();
        this.children().add(node);
        return this;
    }

    public Span span(int from, int length) {
        Span span = new Span(from, length);
        this.add(span);
        return span;
    }

    @Override
    void setInvalid() {
        super.setInvalid();
        for (SpanNode node : this.children()) {
            node.setInvalid();
        }
    }

    public void move(SpanNode node, SpanList target) {
        boolean removed = this.children().remove(node);
        if (!removed) {
            throw new IllegalArgumentException("Node " + String.valueOf(node) + " is not a child of this SpanList, cannot move.");
        }
        node.setParent(null);
        this.resetCachedFromAndTo();
        target.add(node);
    }

    public void move(int nodeNum, SpanList target) {
        SpanNode node = this.children().remove(nodeNum);
        if (node != null) {
            node.setParent(null);
            this.resetCachedFromAndTo();
            target.add(node);
        }
    }

    public void move(SpanNode node, AlternateSpanList target, int targetSubTree) {
        if (targetSubTree < 0 || targetSubTree >= target.getNumSubTrees()) {
            throw new IndexOutOfBoundsException(String.valueOf(target) + " has no subtree at index " + targetSubTree);
        }
        boolean removed = this.children().remove(node);
        if (!removed) {
            throw new IllegalArgumentException("Node " + String.valueOf(node) + " is not a child of this SpanList, cannot move.");
        }
        node.setParent(null);
        this.resetCachedFromAndTo();
        target.add(targetSubTree, node);
    }

    public void move(int nodeNum, AlternateSpanList target, int targetSubTree) {
        if (targetSubTree < 0 || targetSubTree >= target.getNumSubTrees()) {
            throw new IndexOutOfBoundsException(String.valueOf(target) + " has no subtree at index " + targetSubTree);
        }
        SpanNode node = this.children().remove(nodeNum);
        if (node != null) {
            node.setParent(null);
            this.resetCachedFromAndTo();
            target.add(targetSubTree, node);
        }
    }

    public SpanList remove(SpanNode node) {
        boolean removed = this.children().remove(node);
        if (removed) {
            node.setParent(null);
            this.resetCachedFromAndTo();
            node.setInvalid();
        }
        return this;
    }

    public SpanList remove(int i) {
        SpanNode node = this.children().remove(i);
        if (node != null) {
            node.setParent(null);
            node.setInvalid();
        }
        return this;
    }

    protected List<SpanNode> children() {
        return this.children;
    }

    public int numChildren() {
        return this.children().size();
    }

    @Override
    public ListIterator<SpanNode> childIterator() {
        return new InvalidatingIterator(this, this.children().listIterator());
    }

    @Override
    public ListIterator<SpanNode> childIteratorRecursive() {
        return new InvalidatingIterator(this, new RecursiveNodeIterator(this.children().listIterator()));
    }

    public void clearChildren() {
        for (SpanNode node : this.children()) {
            node.setInvalid();
            node.setParent(null);
        }
        this.children().clear();
        this.resetCachedFromAndTo();
    }

    public void sortChildren() {
        Collections.sort(this.children());
    }

    public void sortChildrenRecursive() {
        for (SpanNode node : this.children()) {
            if (node instanceof SpanList) {
                ((SpanList)node).sortChildrenRecursive();
            }
            Collections.sort(this.children());
        }
    }

    @Override
    public boolean isLeafNode() {
        return false;
    }

    private void calculateFrom() {
        int smallestFrom = Integer.MAX_VALUE;
        for (SpanNode n : this.children()) {
            int thisFrom = n.getFrom();
            if (thisFrom == -1) continue;
            smallestFrom = Math.min(thisFrom, smallestFrom);
        }
        if (smallestFrom == Integer.MAX_VALUE) {
            smallestFrom = -1;
        }
        this.cachedFrom = smallestFrom;
    }

    @Override
    public int getFrom() {
        if (this.children().isEmpty()) {
            return -1;
        }
        if (this.cachedFrom == Integer.MIN_VALUE) {
            this.calculateFrom();
        }
        return this.cachedFrom;
    }

    private void calculateTo() {
        int greatestTo = Integer.MIN_VALUE;
        for (SpanNode n : this.children()) {
            greatestTo = Math.max(n.getTo(), greatestTo);
        }
        this.cachedTo = greatestTo;
    }

    @Override
    public int getTo() {
        if (this.children().isEmpty()) {
            return -1;
        }
        if (this.cachedTo == Integer.MIN_VALUE) {
            this.calculateTo();
        }
        return this.cachedTo;
    }

    void resetCachedFromAndTo() {
        this.cachedFrom = Integer.MIN_VALUE;
        this.cachedTo = Integer.MIN_VALUE;
        if (this.getParent() instanceof SpanList) {
            ((SpanList)this.getParent()).resetCachedFromAndTo();
        }
    }

    @Override
    public int getLength() {
        return this.getTo() - this.getFrom();
    }

    @Override
    public CharSequence getText(CharSequence text) {
        if (this.children().isEmpty()) {
            return "";
        }
        StringBuilder str = new StringBuilder();
        for (SpanNode node : this.children()) {
            CharSequence childText = node.getText(text);
            if (childText == null) continue;
            str.append(node.getText(text));
        }
        return str;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SpanList)) {
            return false;
        }
        SpanList spanList = (SpanList)o;
        if (!super.equals(o)) {
            return false;
        }
        return !(this.children() != null ? !this.children().equals(spanList.children()) : spanList.children() != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.children() != null ? this.children().hashCode() : 0);
        return result;
    }

    public String toString() {
        return "SpanList with " + this.children().size() + " children";
    }
}

