/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.json.readers;

import com.fasterxml.jackson.core.JsonToken;
import com.google.common.base.Preconditions;
import com.yahoo.document.DataType;
import com.yahoo.document.Field;
import com.yahoo.document.datatypes.CollectionFieldValue;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.WeightedSet;
import com.yahoo.document.json.TokenBuffer;
import com.yahoo.document.json.readers.ArrayReader;
import com.yahoo.document.json.readers.JsonParserHelpers;
import com.yahoo.document.json.readers.WeightedSetReader;
import com.yahoo.document.update.FieldUpdate;
import java.util.ArrayList;

public class AddRemoveCreator {
    public static void createAdds(TokenBuffer buffer, Field field, FieldUpdate update, boolean ignoreUndefinedFields) {
        AddRemoveCreator.createAddsOrRemoves(buffer, field, update, false, ignoreUndefinedFields);
    }

    public static void createRemoves(TokenBuffer buffer, Field field, FieldUpdate update, boolean ignoreUndefinedFields) {
        AddRemoveCreator.createAddsOrRemoves(buffer, field, update, true, ignoreUndefinedFields);
    }

    private static void createAddsOrRemoves(TokenBuffer buffer, Field field, FieldUpdate update, boolean isRemove, boolean ignoreUndefinedFields) {
        FieldUpdate singleUpdate;
        FieldValue container = field.getDataType().createFieldValue();
        int initNesting = buffer.nesting();
        Preconditions.checkState((boolean)buffer.current().isStructStart(), (String)"Expected start of composite, got %s", (Object)buffer.current());
        if (container instanceof CollectionFieldValue) {
            buffer.next();
            DataType valueType = ((CollectionFieldValue)container).getDataType().getNestedType();
            if (container instanceof WeightedSet) {
                WeightedSet weightedSet = (WeightedSet)container;
                WeightedSetReader.fillWeightedSetUpdate(buffer, initNesting, valueType, weightedSet);
                singleUpdate = isRemove ? FieldUpdate.createRemoveAll(field, weightedSet) : FieldUpdate.createAddAll(field, weightedSet);
            } else {
                ArrayList<FieldValue> arrayContents = new ArrayList<FieldValue>();
                ArrayReader.fillArrayUpdate(buffer, initNesting, valueType, arrayContents, ignoreUndefinedFields);
                if (buffer.current() != JsonToken.END_ARRAY) {
                    throw new IllegalArgumentException("Expected END_ARRAY. Got '" + String.valueOf(buffer.current()) + "'.");
                }
                singleUpdate = isRemove ? FieldUpdate.createRemoveAll(field, arrayContents) : FieldUpdate.createAddAll(field, arrayContents);
            }
        } else {
            throw new UnsupportedOperationException("Trying to add or remove from a field of a type the reader does not know how to handle: " + container.getClass().getName());
        }
        JsonParserHelpers.expectCompositeEnd(buffer.current());
        update.addAll(singleUpdate);
    }
}

