/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.annotation;

import com.yahoo.document.DataType;
import com.yahoo.document.Field;
import com.yahoo.document.annotation.Annotation;
import com.yahoo.document.annotation.AnnotationReferenceDataType;
import com.yahoo.document.annotation.AnnotationType;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.serialization.FieldReader;
import com.yahoo.document.serialization.FieldWriter;
import com.yahoo.document.serialization.XmlStream;
import com.yahoo.vespa.objects.FieldBase;

public class AnnotationReference
extends FieldValue {
    public static int classId = AnnotationReference.registerClass((int)65538, AnnotationReference.class);
    private Annotation reference;
    private AnnotationReferenceDataType dataType;

    public AnnotationReference(AnnotationReferenceDataType type, Annotation reference) {
        this.dataType = type;
        this.setReference(reference);
    }

    public AnnotationReference(AnnotationReferenceDataType type) {
        this(type, null);
    }

    @Override
    public AnnotationReference clone() {
        return (AnnotationReference)super.clone();
    }

    public Annotation getReference() {
        return this.reference;
    }

    @Override
    public void assign(Object o) {
        if (o != null && !(o instanceof Annotation)) {
            throw new IllegalArgumentException("Cannot assign object of type " + o.getClass().getName() + " to an AnnotationReference, must be of type " + Annotation.class.getName());
        }
        this.setReference((Annotation)o);
    }

    public void setReference(Annotation reference) {
        if (reference == null) {
            this.reference = null;
            return;
        }
        AnnotationReferenceDataType type = this.getDataType();
        if (!type.getAnnotationType().isValueCompatible(reference) && !(reference.getType() instanceof AnnotationType)) {
            throw new IllegalArgumentException("Cannot set reference, must be of type " + type + " (was of type " + reference.getType() + ")");
        }
        this.reference = reference;
    }

    public void setReferenceNoCompatibilityCheck(Annotation reference) {
        if (reference == null) {
            this.reference = null;
            return;
        }
        this.reference = reference;
    }

    @Override
    public AnnotationReferenceDataType getDataType() {
        return this.dataType;
    }

    public void setDataType(DataType dataType) {
        if (!(dataType instanceof AnnotationReferenceDataType)) {
            throw new IllegalArgumentException("Cannot set dataType to " + dataType + ", must be of type AnnotationReferenceDataType.");
        }
        this.dataType = (AnnotationReferenceDataType)dataType;
    }

    @Override
    @Deprecated
    public void printXml(XmlStream xml) {
    }

    @Override
    public void clear() {
        this.reference = null;
    }

    @Override
    public void serialize(Field field, FieldWriter writer) {
        writer.write((FieldBase)field, this);
    }

    @Override
    public void deserialize(Field field, FieldReader reader) {
        reader.read((FieldBase)field, this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AnnotationReference)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AnnotationReference that = (AnnotationReference)o;
        return !(this.reference != null ? !this.reference.toString().equals(that.reference.toString()) : that.reference != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.reference != null ? this.reference.toString().hashCode() : 0);
        return result;
    }

    public String toString() {
        return "AnnotationReference " + this.getDataType() + " referring to " + this.reference;
    }

    @Override
    public int compareTo(FieldValue fieldValue) {
        int comp = super.compareTo(fieldValue);
        if (comp == 0) {
            AnnotationReference value = (AnnotationReference)fieldValue;
            comp = this.reference == null ? (value.reference == null ? 0 : -1) : (value.reference == null ? 1 : this.reference.toString().compareTo(value.reference.toString()));
        }
        return comp;
    }
}

