/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.json.readers;

import com.yahoo.collections.Pair;
import com.yahoo.document.Field;
import com.yahoo.document.TensorDataType;
import com.yahoo.document.datatypes.TensorFieldValue;
import com.yahoo.document.json.TokenBuffer;
import com.yahoo.document.json.readers.JsonParserHelpers;
import com.yahoo.document.update.TensorRemoveUpdate;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorAddress;
import com.yahoo.tensor.TensorType;
import java.util.HashMap;
import java.util.Optional;

public class TensorRemoveUpdateReader {
    public static final String TENSOR_ADDRESSES = "addresses";

    static TensorRemoveUpdate createTensorRemoveUpdate(TokenBuffer buffer, Field field) {
        JsonParserHelpers.expectObjectStart(buffer.currentToken());
        TensorRemoveUpdateReader.expectTensorTypeHasSparseDimensions(field);
        TensorDataType tensorDataType = (TensorDataType)field.getDataType();
        TensorType originalType = tensorDataType.getTensorType();
        TensorType sparseType = TensorRemoveUpdate.extractSparseDimensions(originalType);
        Tensor tensor = TensorRemoveUpdateReader.readRemoveUpdateTensor(buffer, sparseType, originalType);
        TensorRemoveUpdateReader.expectAddressesAreNonEmpty(field, tensor);
        return new TensorRemoveUpdate(new TensorFieldValue(tensor));
    }

    private static void expectTensorTypeHasSparseDimensions(Field field) {
        TensorType tensorType = ((TensorDataType)field.getDataType()).getTensorType();
        if (tensorType.dimensions().stream().allMatch(TensorType.Dimension::isIndexed)) {
            throw new IllegalArgumentException("A remove update can only be applied to tensors with at least one sparse dimension. Field '" + field.getName() + "' has unsupported tensor type '" + tensorType + "'");
        }
    }

    private static void expectAddressesAreNonEmpty(Field field, Tensor tensor) {
        if (tensor.isEmpty()) {
            throw new IllegalArgumentException("Remove update for field '" + field.getName() + "' does not contain tensor addresses");
        }
    }

    private static Tensor readRemoveUpdateTensor(TokenBuffer buffer, TensorType sparseType, TensorType originalType) {
        Tensor.Builder builder = null;
        JsonParserHelpers.expectObjectStart(buffer.currentToken());
        int initNesting = buffer.nesting();
        buffer.next();
        while (buffer.nesting() >= initNesting) {
            if (TENSOR_ADDRESSES.equals(buffer.currentName())) {
                JsonParserHelpers.expectArrayStart(buffer.currentToken());
                int nesting = buffer.nesting();
                buffer.next();
                while (buffer.nesting() >= nesting) {
                    if (builder == null) {
                        Pair<TensorType, TensorAddress> typeAndAddress = TensorRemoveUpdateReader.readFirstTensorAddress(buffer, sparseType, originalType);
                        builder = Tensor.Builder.of((TensorType)((TensorType)typeAndAddress.getFirst()));
                        builder.cell((TensorAddress)typeAndAddress.getSecond(), 1.0);
                    } else {
                        builder.cell(TensorRemoveUpdateReader.readTensorAddress(buffer, builder.type(), originalType), 1.0);
                    }
                    buffer.next();
                }
                JsonParserHelpers.expectCompositeEnd(buffer.currentToken());
            }
            buffer.next();
        }
        JsonParserHelpers.expectObjectEnd(buffer.currentToken());
        return builder != null ? builder.build() : Tensor.Builder.of((TensorType)sparseType).build();
    }

    private static Pair<TensorType, TensorAddress> readFirstTensorAddress(TokenBuffer buffer, TensorType sparseType, TensorType originalType) {
        TensorType.Builder typeBuilder = new TensorType.Builder(sparseType.valueType());
        HashMap<String, String> rawAddress = new HashMap<String, String>();
        JsonParserHelpers.expectObjectStart(buffer.currentToken());
        int initNesting = buffer.nesting();
        buffer.next();
        while (buffer.nesting() >= initNesting) {
            Pair<String, String> elem = TensorRemoveUpdateReader.readRawElement(buffer, sparseType, originalType);
            Optional dimension2 = sparseType.dimension((String)elem.getFirst());
            if (!dimension2.isPresent()) {
                throw new IllegalArgumentException(originalType + " does not contain dimension '" + (String)elem.getFirst() + "'");
            }
            typeBuilder.dimension((TensorType.Dimension)dimension2.get());
            rawAddress.put((String)elem.getFirst(), (String)elem.getSecond());
            buffer.next();
        }
        JsonParserHelpers.expectObjectEnd(buffer.currentToken());
        TensorType type = typeBuilder.build();
        TensorAddress.Builder builder = new TensorAddress.Builder(type);
        rawAddress.forEach((dimension, label) -> builder.add(dimension, label));
        return new Pair((Object)type, (Object)builder.build());
    }

    private static Pair<String, String> readRawElement(TokenBuffer buffer, TensorType type, TensorType originalType) {
        String dimension = buffer.currentName();
        if (type.dimension(dimension).isEmpty() && originalType.dimension(dimension).isPresent()) {
            throw new IllegalArgumentException("Indexed dimension address '" + dimension + "' should not be specified in remove update");
        }
        String label = buffer.currentText();
        return new Pair((Object)dimension, (Object)label);
    }

    private static TensorAddress readTensorAddress(TokenBuffer buffer, TensorType type, TensorType originalType) {
        TensorAddress.Builder builder = new TensorAddress.Builder(type);
        JsonParserHelpers.expectObjectStart(buffer.currentToken());
        int initNesting = buffer.nesting();
        buffer.next();
        while (buffer.nesting() >= initNesting) {
            Pair<String, String> elem = TensorRemoveUpdateReader.readRawElement(buffer, type, originalType);
            builder.add((String)elem.getFirst(), (String)elem.getSecond());
            buffer.next();
        }
        JsonParserHelpers.expectObjectEnd(buffer.currentToken());
        return builder.build();
    }
}

