/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.yahoo.document.DataType;
import com.yahoo.document.DataTypeName;
import com.yahoo.document.Document;
import com.yahoo.document.DocumentId;
import com.yahoo.document.DocumentTypeManager;
import com.yahoo.document.Field;
import com.yahoo.document.StructDataType;
import com.yahoo.document.StructuredDataType;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.serialization.DocumentWriter;
import com.yahoo.vespa.objects.ObjectVisitor;
import com.yahoo.vespa.objects.Serializer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;

public class DocumentType
extends StructuredDataType {
    public static final int classId = DocumentType.registerClass((int)4154, DocumentType.class);
    private StructDataType headerType;
    private StructDataType bodyType;
    private List<DocumentType> inherits = new ArrayList<DocumentType>(1);

    public DocumentType(String name) {
        this(name, new StructDataType(name + ".header"), new StructDataType(name + ".body"));
    }

    public DocumentType(String name, StructDataType headerType, StructDataType bodyType) {
        super(name);
        this.headerType = headerType;
        this.bodyType = bodyType;
    }

    @Override
    public DocumentType clone() {
        DocumentType type = (DocumentType)super.clone();
        type.headerType = this.headerType.clone();
        type.bodyType = this.bodyType.clone();
        type.inherits = new ArrayList<DocumentType>(this.inherits.size());
        for (DocumentType inherited : this.inherits) {
            type.inherits.add(inherited);
        }
        return type;
    }

    @Override
    public Document createFieldValue() {
        return new Document(this, (DocumentId)null);
    }

    @Override
    public Class getValueClass() {
        return Document.class;
    }

    @Override
    public boolean isValueCompatible(FieldValue value) {
        if (!(value instanceof Document)) {
            return false;
        }
        Document doc = (Document)value;
        return doc.getDataType().inherits(this);
    }

    public StructDataType contentStruct() {
        return this.headerType;
    }

    @Deprecated
    public StructDataType getHeaderType() {
        return this.contentStruct();
    }

    @Deprecated
    public StructDataType getBodyType() {
        return this.bodyType;
    }

    @Override
    protected void register(DocumentTypeManager manager, List<DataType> seenTypes) {
        seenTypes.add(this);
        for (DocumentType type : this.getInheritedTypes()) {
            if (seenTypes.contains(type)) continue;
            type.register(manager, seenTypes);
        }
        StructDataType header = this.headerType.clone();
        StructDataType body = this.bodyType.clone();
        header.clearFields();
        body.clearFields();
        for (Field field : this.fieldSet()) {
            (field.isHeader() ? header : body).addField(field);
        }
        this.headerType.assign(header);
        this.bodyType.assign(body);
        if (!seenTypes.contains(this.headerType)) {
            this.headerType.register(manager, seenTypes);
        }
        if (!seenTypes.contains(this.bodyType)) {
            this.bodyType.register(manager, seenTypes);
        }
        manager.registerSingleType(this);
    }

    public boolean isA(String docTypeName) {
        if (this.getName().equalsIgnoreCase(docTypeName)) {
            return true;
        }
        for (DocumentType parent : this.inherits) {
            if (!parent.isA(docTypeName)) continue;
            return true;
        }
        return false;
    }

    public void addField(Field field) {
        if (this.isRegistered()) {
            throw new IllegalStateException("You cannot add fields to a document type that is already registered.");
        }
        StructDataType struct = field.isHeader() ? this.headerType : this.bodyType;
        struct.addField(field);
    }

    public Field addField(String name, DataType type) {
        if (this.isRegistered()) {
            throw new IllegalStateException("You cannot add fields to a document type that is already registered.");
        }
        Field field = new Field(name, type, false);
        this.bodyType.addField(field);
        return field;
    }

    public Field addHeaderField(String name, DataType type) {
        if (this.isRegistered()) {
            throw new IllegalStateException("You cannot add fields to a document type that is already registered.");
        }
        Field field = new Field(name, type, true);
        this.headerType.addField(field);
        return field;
    }

    public void inherit(DocumentType type) {
        this.verifyTypeConsistency(type);
        if (this.isRegistered()) {
            throw new IllegalStateException("You cannot add inheritance to a document type that is already registered.");
        }
        if (type == null) {
            throw new IllegalArgumentException("The document type cannot be null in inherit()");
        }
        if (this.inherits.contains(type)) {
            return;
        }
        if (this.inherits.size() == 1 && this.inherits.get(0).getDataTypeName().equals(new DataTypeName("document"))) {
            this.inherits.clear();
        }
        this.inherits.add(type);
    }

    private void verifyTypeConsistency(DocumentType superType) {
        for (Field f : this.fieldSet()) {
            Field supField = superType.getField(f.getName());
            if (supField == null || f.getDataType().equals(supField.getDataType())) continue;
            throw new IllegalArgumentException("Inheritance type mismatch: field \"" + f.getName() + "\" in datatype \"" + this.getName() + "\" must have same datatype as in parent document type \"" + superType.getName() + "\"");
        }
    }

    public Collection<DocumentType> getInheritedTypes() {
        return Collections.unmodifiableCollection(this.inherits);
    }

    public ListIterator<DataTypeName> inheritedIterator() {
        ArrayList<DataTypeName> names = new ArrayList<DataTypeName>(this.inherits.size());
        for (DocumentType type : this.inherits) {
            names.add(type.getDataTypeName());
        }
        return ImmutableList.copyOf(names).listIterator();
    }

    public boolean inherits(DocumentType superType) {
        if (this.equals(superType)) {
            return true;
        }
        for (DocumentType type : this.inherits) {
            if (!type.inherits(superType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Field getField(String name) {
        Field field;
        block2: {
            DocumentType inheritedType;
            field = this.headerType.getField(name);
            if (field == null) {
                field = this.bodyType.getField(name);
            }
            if (field != null || this.isRegistered()) break block2;
            Iterator<DocumentType> iterator = this.inherits.iterator();
            while (iterator.hasNext() && (field = (inheritedType = iterator.next()).getField(name)) == null) {
            }
        }
        return field;
    }

    @Override
    public Field getField(int id) {
        Field field;
        block2: {
            DocumentType inheritedType;
            field = this.headerType.getField(id);
            if (field == null) {
                field = this.bodyType.getField(id);
            }
            if (field != null || this.isRegistered()) break block2;
            Iterator<DocumentType> iterator = this.inherits.iterator();
            while (iterator.hasNext() && (field = (inheritedType = iterator.next()).getField(id)) == null) {
            }
        }
        return field;
    }

    public boolean hasField(String name) {
        return this.getField(name) != null;
    }

    public int getFieldCount() {
        return this.headerType.getFieldCount() + this.bodyType.getFieldCount();
    }

    public Field removeField(String name) {
        Field field;
        block3: {
            DocumentType inheritedType;
            if (this.isRegistered()) {
                throw new IllegalStateException("You cannot remove fields from a document type that is already registered.");
            }
            field = this.headerType.removeField(name);
            if (field == null) {
                field = this.bodyType.removeField(name);
            }
            if (field != null) break block3;
            Iterator<DocumentType> iterator = this.inherits.iterator();
            while (iterator.hasNext() && (field = (inheritedType = iterator.next()).removeField(name)) == null) {
            }
        }
        return field;
    }

    @Override
    public Collection<Field> getFields() {
        LinkedList<Field> collection = new LinkedList<Field>();
        for (DocumentType type : this.inherits) {
            collection.addAll(type.getFields());
        }
        collection.addAll(this.headerType.getFields());
        collection.addAll(this.bodyType.getFields());
        return ImmutableList.copyOf(collection);
    }

    public Set<Field> fieldSet() {
        LinkedHashMap<String, Field> map = new LinkedHashMap<String, Field>();
        for (Field field : this.getFields()) {
            map.put(field.getName(), field);
        }
        return ImmutableSet.copyOf(map.values());
    }

    public Iterator<Field> fieldIteratorThisTypeOnly() {
        return new Iterator<Field>(){
            Iterator<Field> headerIt;
            Iterator<Field> bodyIt;
            {
                this.headerIt = DocumentType.this.headerType.getFields().iterator();
                this.bodyIt = DocumentType.this.bodyType.getFields().iterator();
            }

            @Override
            public boolean hasNext() {
                if (this.headerIt != null) {
                    if (this.headerIt.hasNext()) {
                        return true;
                    }
                    this.headerIt = null;
                }
                return this.bodyIt.hasNext();
            }

            @Override
            public Field next() {
                return this.headerIt != null ? this.headerIt.next() : this.bodyIt.next();
            }

            @Override
            public void remove() {
                if (this.headerIt != null) {
                    this.headerIt.remove();
                } else {
                    this.bodyIt.remove();
                }
            }
        };
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof DocumentType)) {
            return false;
        }
        DocumentType other = (DocumentType)o;
        if (super.equals(o) && this.headerType.equals(other.headerType) && this.bodyType.equals(other.bodyType)) {
            if (this.inherits.size() > 1 || other.inherits.size() > 1 || this.inherits.size() == 1 && other.inherits.size() == 1) {
                return this.inherits.equals(other.inherits);
            }
            return !(this.inherits.size() == 1 && !this.inherits.get(0).getDataTypeName().equals(new DataTypeName("document")) || other.inherits.size() == 1 && !other.inherits.get(0).getDataTypeName().equals(new DataTypeName("document")));
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.headerType.hashCode() + this.bodyType.hashCode() + this.inherits.hashCode();
    }

    public void onSerialize(Serializer target) {
        if (target instanceof DocumentWriter) {
            ((DocumentWriter)target).write(this);
        }
    }

    @Override
    public void visitMembers(ObjectVisitor visitor) {
        super.visitMembers(visitor);
        visitor.visit("headertype", (Object)this.headerType);
        visitor.visit("bodytype", (Object)this.bodyType);
        visitor.visit("inherits", this.inherits);
    }
}

