/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.annotation;

import com.yahoo.document.annotation.SpanNode;
import com.yahoo.document.serialization.SpanNodeReader;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class Span
extends SpanNode {
    public static final byte ID = 1;
    private int from;
    private int length;

    public Span(int from, int length) {
        this.setFrom(from);
        this.setLength(length);
    }

    public Span(SpanNodeReader reader) {
        reader.read(this);
    }

    public Span() {
    }

    public Span(Span spanToCopy) {
        this(spanToCopy.getFrom(), spanToCopy.getLength());
    }

    @Override
    public final int getFrom() {
        return this.from;
    }

    public void setFrom(int from) {
        if (from < 0) {
            throw new IllegalArgumentException("From cannot be < 0. (Was " + from + ").");
        }
        this.from = from;
    }

    @Override
    public final int getTo() {
        return this.from + this.length;
    }

    @Override
    public final int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("Length cannot be < 0. (Was " + length + ").");
        }
        this.length = length;
    }

    public String toString() {
        return "span [" + this.from + ',' + this.getTo() + '>';
    }

    @Override
    public final CharSequence getText(CharSequence text) {
        return text.subSequence(this.from, this.getTo());
    }

    @Override
    public boolean isLeafNode() {
        return true;
    }

    @Override
    public ListIterator<SpanNode> childIterator() {
        return new EmptyIterator();
    }

    @Override
    public ListIterator<SpanNode> childIteratorRecursive() {
        return this.childIterator();
    }

    private class EmptyIterator
    implements ListIterator<SpanNode> {
        private EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public SpanNode next() {
            throw new NoSuchElementException("A Span has no children");
        }

        @Override
        public boolean hasPrevious() {
            return false;
        }

        @Override
        public SpanNode previous() {
            throw new NoSuchElementException("A Span has no children");
        }

        @Override
        public int nextIndex() {
            return 0;
        }

        @Override
        public int previousIndex() {
            return 0;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("A Span has no children");
        }

        @Override
        public void set(SpanNode spanNode) {
            throw new UnsupportedOperationException("A Span has no children");
        }

        @Override
        public void add(SpanNode spanNode) {
            throw new UnsupportedOperationException("A Span has no children");
        }
    }
}

