/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.update;

import com.yahoo.document.DataType;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.WeightedSet;
import com.yahoo.document.serialization.DocumentUpdateWriter;
import com.yahoo.document.update.AddValueUpdate;
import com.yahoo.document.update.ArithmeticValueUpdate;
import com.yahoo.document.update.AssignValueUpdate;
import com.yahoo.document.update.ClearValueUpdate;
import com.yahoo.document.update.MapValueUpdate;
import com.yahoo.document.update.RemoveValueUpdate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class ValueUpdate<T extends FieldValue> {
    protected ValueUpdateClassID valueUpdateClassID;

    protected ValueUpdate(ValueUpdateClassID valueUpdateClassID) {
        this.valueUpdateClassID = valueUpdateClassID;
    }

    public ValueUpdateClassID getValueUpdateClassID() {
        return this.valueUpdateClassID;
    }

    protected abstract void checkCompatibility(DataType var1);

    public abstract void serialize(DocumentUpdateWriter var1, DataType var2);

    public boolean equals(Object o) {
        return o instanceof ValueUpdate && this.valueUpdateClassID == ((ValueUpdate)o).valueUpdateClassID;
    }

    public int hashCode() {
        return this.valueUpdateClassID.id;
    }

    public String toString() {
        return this.valueUpdateClassID.name;
    }

    public abstract FieldValue applyTo(FieldValue var1);

    public static ValueUpdate createAdd(FieldValue value) {
        return new AddValueUpdate(value);
    }

    public static ValueUpdate createAdd(FieldValue key, Integer weight) {
        return new AddValueUpdate(key, weight);
    }

    public static List<ValueUpdate> createAddAll(List<? extends FieldValue> values) {
        ArrayList<ValueUpdate> vupds = new ArrayList<ValueUpdate>();
        for (FieldValue fieldValue : values) {
            vupds.add(ValueUpdate.createAdd(fieldValue));
        }
        return vupds;
    }

    public static List<ValueUpdate> createAddAll(WeightedSet<? extends FieldValue> set) {
        ArrayList<ValueUpdate> vupds = new ArrayList<ValueUpdate>();
        Iterator<? extends FieldValue> it = set.fieldValueIterator();
        while (it.hasNext()) {
            FieldValue key = it.next();
            vupds.add(ValueUpdate.createAdd(key, set.get(key)));
        }
        return vupds;
    }

    public static ValueUpdate createIncrement(Number increment) {
        return new ArithmeticValueUpdate(ArithmeticValueUpdate.Operator.ADD, increment);
    }

    public static ValueUpdate createIncrement(FieldValue key, Number increment) {
        return ValueUpdate.createMap(key, ValueUpdate.createIncrement(increment));
    }

    public static ValueUpdate createDecrement(Number decrement) {
        return new ArithmeticValueUpdate(ArithmeticValueUpdate.Operator.SUB, decrement);
    }

    public static ValueUpdate createDecrement(FieldValue key, Number decrement) {
        return ValueUpdate.createMap(key, ValueUpdate.createDecrement(decrement));
    }

    public static ValueUpdate createMultiply(Number factor) {
        return new ArithmeticValueUpdate(ArithmeticValueUpdate.Operator.MUL, factor);
    }

    public static ValueUpdate createMultiply(FieldValue key, Number factor) {
        return ValueUpdate.createMap(key, ValueUpdate.createMultiply(factor));
    }

    public static ValueUpdate createDivide(Number divisor) {
        return new ArithmeticValueUpdate(ArithmeticValueUpdate.Operator.DIV, divisor);
    }

    public static ValueUpdate createDivide(FieldValue key, Number divisor) {
        return ValueUpdate.createMap(key, ValueUpdate.createDivide(divisor));
    }

    public static ValueUpdate createAssign(FieldValue newValue) {
        return new AssignValueUpdate(newValue);
    }

    public static ValueUpdate createClear() {
        return new ClearValueUpdate();
    }

    public static ValueUpdate createMap(FieldValue value, ValueUpdate update) {
        return new MapValueUpdate(value, update);
    }

    public static ValueUpdate createRemove(FieldValue value) {
        return new RemoveValueUpdate(value);
    }

    public static List<ValueUpdate> createRemoveAll(List<? extends FieldValue> values) {
        ArrayList<ValueUpdate> vupds = new ArrayList<ValueUpdate>();
        for (FieldValue fieldValue : values) {
            vupds.add(ValueUpdate.createRemove(fieldValue));
        }
        return vupds;
    }

    public static List<ValueUpdate> createRemoveAll(WeightedSet<? extends FieldValue> values) {
        ArrayList<ValueUpdate> vupds = new ArrayList<ValueUpdate>();
        for (FieldValue fieldValue : values.keySet()) {
            vupds.add(ValueUpdate.createRemove(fieldValue));
        }
        return vupds;
    }

    public abstract T getValue();

    public abstract void setValue(T var1);

    public static enum ValueUpdateClassID {
        ADD(25, "add"),
        ARITHMETIC(26, "arithmetic"),
        ASSIGN(27, "assign"),
        CLEAR(28, "clear"),
        MAP(29, "map"),
        REMOVE(30, "remove"),
        TENSORMODIFY(100, "tensormodify");

        public final int id;
        public final String name;

        private ValueUpdateClassID(int id, String name) {
            this.id = 4096 + id;
            this.name = name;
        }

        public static ValueUpdateClassID getID(int id) {
            for (ValueUpdateClassID vucid : ValueUpdateClassID.values()) {
                if (vucid.id != id) continue;
                return vucid;
            }
            return null;
        }
    }
}

