/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.update;

import com.yahoo.document.DataType;
import com.yahoo.document.TensorDataType;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.TensorFieldValue;
import com.yahoo.document.serialization.DocumentUpdateWriter;
import com.yahoo.document.update.ValueUpdate;

public class TensorModifyUpdate
extends ValueUpdate<TensorFieldValue> {
    protected Operation operation;
    protected TensorFieldValue tensor;

    public TensorModifyUpdate(Operation operation, TensorFieldValue tensor) {
        super(ValueUpdate.ValueUpdateClassID.TENSORMODIFY);
        this.operation = operation;
        this.tensor = tensor;
    }

    public Operation getOperation() {
        return this.operation;
    }

    @Override
    public TensorFieldValue getValue() {
        return this.tensor;
    }

    @Override
    public void setValue(TensorFieldValue value) {
        this.tensor = value;
    }

    @Override
    public FieldValue applyTo(FieldValue oldValue) {
        if (!(oldValue instanceof TensorFieldValue)) {
            throw new IllegalStateException("Cannot use tensor modify update on non-tensor datatype " + oldValue.getClass().getName());
        }
        return oldValue;
    }

    @Override
    protected void checkCompatibility(DataType fieldType) {
        if (!(fieldType instanceof TensorDataType)) {
            throw new UnsupportedOperationException("Expected tensor type, got " + fieldType.getName() + ".");
        }
    }

    @Override
    public void serialize(DocumentUpdateWriter data, DataType superType) {
        data.write(this);
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof TensorModifyUpdate && super.equals(o) && this.operation == ((TensorModifyUpdate)o).operation && this.tensor.equals(((TensorModifyUpdate)o).tensor);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.operation.hashCode() + this.tensor.hashCode();
    }

    @Override
    public String toString() {
        return super.toString() + " " + this.operation.name + " " + this.tensor;
    }

    public static enum Operation {
        REPLACE(0, "replace"),
        ADD(1, "add"),
        MULTIPLY(2, "multiply");

        public final int id;
        public final String name;

        private Operation(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public static Operation getOperation(int id) {
            for (Operation operation : Operation.values()) {
                if (operation.id != id) continue;
                return operation;
            }
            return null;
        }
    }
}

