/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.idstring;

import com.yahoo.collections.MD5;
import com.yahoo.document.idstring.IdString;
import com.yahoo.text.Utf8;
import java.security.MessageDigest;

public class IdIdString
extends IdString {
    private String type;
    private String group;
    private long location;
    private boolean hasGroup;
    private boolean hasNumber;

    public static String replaceType(String id, String typeName) {
        int typeStartPos = id.indexOf(":", 3) + 1;
        int typeEndPos = id.indexOf(":", typeStartPos);
        return id.substring(0, typeStartPos) + typeName + id.substring(typeEndPos);
    }

    public static long makeLocation(String s) {
        long result = 0L;
        byte[] md5sum = ((MessageDigest)MD5.md5.get()).digest(Utf8.toBytes((String)s));
        for (int i = 0; i < 8; ++i) {
            result |= ((long)md5sum[i] & 0xFFL) << 8 * i;
        }
        return result;
    }

    public IdIdString(String namespace, String type, String keyValues, String localId) {
        super(IdString.Scheme.id, namespace, localId);
        this.type = type;
        boolean hasSetLocation = false;
        if (namespace.length() + type.length() + keyValues.length() + 5 >= 65534) {
            throw new IllegalArgumentException("Length of namespace(" + namespace.length() + ") + doctype(" + type.length() + ") + key/values(" + keyValues.length() + "), is longer than 65529");
        }
        block8: for (String pair : keyValues.split(",")) {
            int pos = pair.indexOf(61);
            if (pos == -1) {
                if (pair.equals("")) continue;
                throw new IllegalArgumentException("Illegal key-value pair '" + pair + "'");
            }
            String key = pair.substring(0, pos);
            String value = pair.substring(pos + 1);
            switch (key) {
                case "n": {
                    if (hasSetLocation) {
                        throw new IllegalArgumentException("Illegal key combination in " + keyValues);
                    }
                    if (value.isEmpty()) {
                        throw new IllegalArgumentException("ID location value for 'n=' key is empty");
                    }
                    this.location = Long.parseLong(value);
                    hasSetLocation = true;
                    this.hasNumber = true;
                    continue block8;
                }
                case "g": {
                    if (hasSetLocation) {
                        throw new IllegalArgumentException("Illegal key combination in " + keyValues);
                    }
                    if (value.isEmpty()) {
                        throw new IllegalArgumentException("ID location value for 'g=' key is empty");
                    }
                    this.location = IdIdString.makeLocation(value);
                    hasSetLocation = true;
                    this.hasGroup = true;
                    this.group = value;
                    continue block8;
                }
                default: {
                    throw new IllegalArgumentException("Illegal key '" + key + "'");
                }
            }
        }
        if (!hasSetLocation) {
            this.location = IdIdString.makeLocation(localId);
        }
    }

    @Override
    public long getLocation() {
        return this.location;
    }

    @Override
    public String getSchemeSpecific() {
        if (this.hasGroup) {
            return this.type + ":g=" + this.group + ":";
        }
        if (this.hasNumber) {
            return this.type + ":n=" + this.location + ":";
        }
        return this.type + "::";
    }

    @Override
    public boolean hasDocType() {
        return true;
    }

    @Override
    public String getDocType() {
        return this.type;
    }

    @Override
    public boolean hasGroup() {
        return this.hasGroup;
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public boolean hasNumber() {
        return this.hasNumber;
    }

    @Override
    public long getNumber() {
        return this.location;
    }
}

