/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document;

import com.yahoo.collections.BobHash;
import com.yahoo.document.DataType;
import com.yahoo.document.DocumentType;
import com.yahoo.document.fieldset.DocIdOnly;
import com.yahoo.document.fieldset.FieldSet;
import com.yahoo.document.fieldset.NoFields;
import com.yahoo.vespa.objects.FieldBase;
import java.io.Serializable;

public class Field
extends FieldBase
implements FieldSet,
Comparable,
Serializable {
    protected DataType dataType;
    protected int fieldId;
    private boolean isHeader;
    private boolean forcedId;

    public Field(String name, int id, DataType dataType, boolean isHeader) {
        super(name);
        this.fieldId = id;
        this.dataType = dataType;
        this.isHeader = isHeader;
        this.forcedId = true;
        this.validateId(id, null);
    }

    public Field(String name) {
        this(name, DataType.NONE);
    }

    public Field(String name, DataType dataType, boolean isHeader, DocumentType owner) {
        this(name, 0, dataType, isHeader);
        this.fieldId = this.calculateIdV7(owner);
        this.forcedId = false;
    }

    public Field(String name, DataType dataType, boolean isHeader) {
        this(name, dataType, isHeader, null);
    }

    public Field(String name, DataType dataType) {
        this(name, dataType, true);
    }

    public Field(String name, Field field) {
        this(name, field.dataType, field.isHeader, null);
    }

    public int compareTo(Object o) {
        return this.fieldId - ((Field)o).fieldId;
    }

    protected int calculateIdV7(DocumentType owner) {
        String combined = this.getName() + this.dataType.getId();
        int newId = BobHash.hash((String)combined);
        if (newId < 0) {
            newId = -newId;
        }
        this.validateId(newId, owner);
        return newId;
    }

    public void setId(int newId, DocumentType owner) {
        if (owner == null) {
            throw new NullPointerException("Can not assign an id of " + this + " without knowing the owner");
        }
        this.validateId(newId, owner);
        owner.removeField(this.getName());
        this.fieldId = newId;
        this.forcedId = true;
        owner.addField(this);
    }

    private void validateId(int newId, DocumentType owner) {
        if (newId >= 100 && newId <= 127) {
            throw new IllegalArgumentException("Attempt to set the id of " + this + " to " + newId + " failed, values from 100 to 127 are reserved for internal use");
        }
        if ((newId & Integer.MIN_VALUE) != 0) {
            throw new IllegalArgumentException("Attempt to set the id of " + this + " to " + newId + " failed, negative id values  are illegal");
        }
        if (owner == null) {
            return;
        }
        Field existing = owner.getField(newId);
        if (existing != null && !existing.getName().equals(this.getName())) {
            throw new IllegalArgumentException("Couldn't set id of " + this + " to " + newId + ", " + existing + " already has this id in " + owner);
        }
    }

    public final DataType getDataType() {
        return this.dataType;
    }

    @Deprecated
    public void setDataType(DataType type) {
        this.dataType = type;
        this.fieldId = this.calculateIdV7(null);
        this.forcedId = false;
    }

    @Deprecated
    public final int getId(int version) {
        return this.getId();
    }

    public final int getId() {
        return this.fieldId;
    }

    public final boolean hasForcedId() {
        return this.forcedId;
    }

    @Deprecated
    public boolean isHeader() {
        return this.isHeader;
    }

    @Deprecated
    public void setHeader(boolean header) {
        this.isHeader = header;
    }

    public boolean equals(Object o) {
        return this == o || o instanceof Field && super.equals(o) && this.dataType.equals(((Field)o).dataType);
    }

    public int hashCode() {
        return this.getId();
    }

    public String toString() {
        return super.toString() + "(" + this.dataType + ")";
    }

    @Override
    public boolean contains(FieldSet o) {
        if (o instanceof NoFields || o instanceof DocIdOnly) {
            return true;
        }
        if (o instanceof Field) {
            return this.equals(o);
        }
        return false;
    }

    @Override
    public FieldSet clone() throws CloneNotSupportedException {
        return (Field)super.clone();
    }
}

