/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.annotation;

import com.yahoo.document.annotation.PeekableListIterator;
import com.yahoo.document.annotation.SpanNode;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Stack;

class RecursiveNodeIterator
implements ListIterator<SpanNode> {
    protected Stack<PeekableListIterator<SpanNode>> stack = new Stack();
    protected ListIterator<SpanNode> iteratorFromLastCallToNext = null;

    RecursiveNodeIterator(ListIterator<SpanNode> it) {
        this.stack.push(new PeekableListIterator<SpanNode>(it));
    }

    protected RecursiveNodeIterator() {
    }

    @Override
    public boolean hasNext() {
        if (this.stack.isEmpty()) {
            return false;
        }
        PeekableListIterator<SpanNode> iterator = this.stack.peek();
        if (!iterator.hasNext()) {
            this.stack.pop();
            return this.hasNext();
        }
        SpanNode node = iterator.peek();
        if (!iterator.traversed) {
            iterator.traversed = true;
            this.stack.push(new PeekableListIterator<SpanNode>(node.childIterator()));
            return this.hasNext();
        }
        return true;
    }

    @Override
    public SpanNode next() {
        if (this.stack.isEmpty() || !this.hasNext()) {
            this.iteratorFromLastCallToNext = null;
            throw new NoSuchElementException("No next element available.");
        }
        this.stack.peek().traversed = false;
        this.iteratorFromLastCallToNext = this.stack.peek();
        return this.stack.peek().next();
    }

    @Override
    public boolean hasPrevious() {
        throw new UnsupportedOperationException();
    }

    @Override
    public SpanNode previous() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int nextIndex() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int previousIndex() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove() {
        if (this.stack.isEmpty()) {
            throw new IllegalStateException();
        }
        if (this.iteratorFromLastCallToNext == null) {
            throw new IllegalStateException();
        }
        this.iteratorFromLastCallToNext.remove();
    }

    @Override
    public void set(SpanNode spanNode) {
        if (this.stack.isEmpty()) {
            throw new IllegalStateException();
        }
        if (this.iteratorFromLastCallToNext == null) {
            throw new IllegalStateException();
        }
        this.iteratorFromLastCallToNext.set(spanNode);
    }

    @Override
    public void add(SpanNode spanNode) {
        throw new UnsupportedOperationException();
    }
}

