/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.docprocs.indexing;

import com.yahoo.docprocs.indexing.DocumentScript;
import com.yahoo.document.DocumentType;
import com.yahoo.document.DocumentTypeManager;
import com.yahoo.language.Linguistics;
import com.yahoo.language.process.Embedder;
import com.yahoo.vespa.configdefinition.IlscriptsConfig;
import com.yahoo.vespa.indexinglanguage.ScriptParserContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.InputExpression;
import com.yahoo.vespa.indexinglanguage.expressions.OutputExpression;
import com.yahoo.vespa.indexinglanguage.expressions.ScriptExpression;
import com.yahoo.vespa.indexinglanguage.expressions.StatementExpression;
import com.yahoo.vespa.indexinglanguage.parser.CharStream;
import com.yahoo.vespa.indexinglanguage.parser.IndexingInput;
import com.yahoo.vespa.indexinglanguage.parser.ParseException;
import com.yahoo.vespa.objects.ObjectOperation;
import com.yahoo.vespa.objects.ObjectPredicate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ScriptManager {
    private static final String FULL = "[all]";
    private final Map<String, Map<String, DocumentScript>> documentFieldScripts;
    private final DocumentTypeManager documentTypeManager;

    public ScriptManager(DocumentTypeManager documentTypeManager, IlscriptsConfig config, Linguistics linguistics, Map<String, Embedder> embedders) {
        this.documentTypeManager = documentTypeManager;
        this.documentFieldScripts = ScriptManager.createScriptsMap(documentTypeManager, config, linguistics, embedders);
    }

    private Map<String, DocumentScript> getScripts(DocumentType inputType) {
        Map<String, DocumentScript> scripts = this.documentFieldScripts.get(inputType.getName());
        if (scripts != null) {
            return scripts;
        }
        for (Map.Entry<String, Map<String, DocumentScript>> entry : this.documentFieldScripts.entrySet()) {
            if (!inputType.inherits(this.documentTypeManager.getDocumentType(entry.getKey()))) continue;
            return entry.getValue();
        }
        for (Map.Entry<String, Map<String, DocumentScript>> entry : this.documentFieldScripts.entrySet()) {
            if (!this.documentTypeManager.getDocumentType(entry.getKey()).inherits(inputType)) continue;
            return entry.getValue();
        }
        return null;
    }

    public DocumentScript getScript(DocumentType inputType) {
        return this.getScript(inputType, FULL);
    }

    public DocumentScript getScript(DocumentType inputType, String inputFieldName) {
        DocumentScript script;
        Map<String, DocumentScript> fieldScripts = this.getScripts(inputType);
        if (fieldScripts != null && (script = fieldScripts.get(inputFieldName)) != null) {
            return script;
        }
        return null;
    }

    private static Map<String, Map<String, DocumentScript>> createScriptsMap(DocumentTypeManager documentTypes, IlscriptsConfig config, Linguistics linguistics, Map<String, Embedder> embedders) {
        HashMap documentFieldScripts = new HashMap(config.ilscript().size());
        ScriptParserContext parserContext = new ScriptParserContext(linguistics, embedders);
        parserContext.getAnnotatorConfig().setMaxTermOccurrences(config.maxtermoccurrences());
        parserContext.getAnnotatorConfig().setMaxTokenizeLength(config.fieldmatchmaxlength());
        for (IlscriptsConfig.Ilscript ilscript : config.ilscript()) {
            DocumentType documentType = documentTypes.getDocumentType(ilscript.doctype());
            InputExpression.FieldPathOptimizer fieldPathOptimizer = new InputExpression.FieldPathOptimizer(documentType);
            ArrayList<StatementExpression> allStatements = new ArrayList<StatementExpression>(ilscript.content().size());
            HashMap<String, DocumentScript> fieldScripts = new HashMap<String, DocumentScript>(ilscript.content().size());
            for (String content : ilscript.content()) {
                ScriptExpression fieldScript;
                StatementExpression statement = ScriptManager.parse(documentType, parserContext, content);
                allStatements.add(statement);
                List inputFieldNames = InputExpression.InputFieldNameExtractor.runOn((Expression)statement);
                OutputExpression.OutputFieldNameExtractor outputFieldNameExtractor = new OutputExpression.OutputFieldNameExtractor();
                statement.select((ObjectPredicate)outputFieldNameExtractor, (ObjectOperation)outputFieldNameExtractor);
                statement.select((ObjectPredicate)fieldPathOptimizer, (ObjectOperation)fieldPathOptimizer);
                if (!outputFieldNameExtractor.getOutputFieldNames().isEmpty()) {
                    String outputFieldName = (String)outputFieldNameExtractor.getOutputFieldNames().get(0);
                    statement.setStatementOutput(documentType, documentType.getField(outputFieldName));
                }
                if (inputFieldNames.size() != 1) continue;
                String fieldName = (String)inputFieldNames.get(0);
                if (fieldScripts.containsKey(fieldName)) {
                    DocumentScript existing = (DocumentScript)fieldScripts.get(fieldName);
                    ArrayList<StatementExpression> appendedList = new ArrayList<StatementExpression>(((ScriptExpression)existing.getExpression()).asList());
                    appendedList.add(statement);
                    fieldScript = new ScriptExpression(appendedList);
                } else {
                    fieldScript = new ScriptExpression(new StatementExpression[]{statement});
                }
                fieldScripts.put(fieldName, new DocumentScript(documentType, inputFieldNames, fieldScript));
            }
            ScriptExpression script = new ScriptExpression(allStatements);
            script.select((ObjectPredicate)fieldPathOptimizer, (ObjectOperation)fieldPathOptimizer);
            fieldScripts.put(FULL, new DocumentScript(documentType, ilscript.docfield(), script));
            documentFieldScripts.put(ilscript.doctype(), Collections.unmodifiableMap(fieldScripts));
        }
        return Collections.unmodifiableMap(documentFieldScripts);
    }

    private static StatementExpression parse(DocumentType type, ScriptParserContext parserConfig, String content) {
        try {
            parserConfig.setInputStream((CharStream)new IndexingInput(content));
            return StatementExpression.newInstance((ScriptParserContext)parserConfig);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Illegal indexing script for " + type, e);
        }
    }
}

