/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.docproc;

import com.yahoo.component.AbstractComponent;
import com.yahoo.component.ComponentId;
import com.yahoo.concurrent.DaemonThreadFactory;
import com.yahoo.docproc.CallStack;
import com.yahoo.docproc.DocprocExecutor;
import com.yahoo.docproc.DocumentProcessor;
import com.yahoo.docproc.HandledProcessingException;
import com.yahoo.docproc.Processing;
import com.yahoo.docproc.ProcessingEndpoint;
import com.yahoo.docproc.proxy.SchemaMap;
import com.yahoo.document.DocumentOperation;
import com.yahoo.document.DocumentTypeManager;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

@Deprecated(forRemoval=true, since="7")
public class DocprocService
extends AbstractComponent {
    private static final Logger log = Logger.getLogger(DocprocService.class.getName());
    private volatile DocprocExecutor executor;
    private final LinkedBlockingQueue<Processing> queue = new LinkedBlockingQueue();
    private final ThreadPoolExecutor threadPool;
    private boolean inService = false;
    private boolean acceptingNewProcessings = true;
    public static SchemaMap schemaMap = new SchemaMap();
    private DocumentTypeManager documentTypeManager = null;

    private DocprocService(ComponentId id, int numThreads) {
        super(id);
        this.threadPool = new ThreadPoolExecutor(numThreads, numThreads, 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new DaemonThreadFactory("docproc-" + id.stringValue() + "-"));
    }

    public DocprocService(ComponentId id) {
        this(id, Runtime.getRuntime().availableProcessors());
    }

    public DocprocService(ComponentId id, CallStack stack, DocumentTypeManager mgr, int numThreads) {
        this(id, numThreads);
        this.setCallStack(stack);
        this.setDocumentTypeManager(mgr);
        this.setInService(true);
    }

    @Deprecated
    public DocprocService(ComponentId id, CallStack stack, DocumentTypeManager mgr) {
        this(id, stack, mgr, Runtime.getRuntime().availableProcessors());
    }

    public DocprocService(String name) {
        this(new ComponentId(name, null), 1);
    }

    public void deconstruct() {
        this.threadPool.shutdown();
    }

    public DocumentTypeManager getDocumentTypeManager() {
        return this.documentTypeManager;
    }

    public void setDocumentTypeManager(DocumentTypeManager documentTypeManager) {
        this.documentTypeManager = documentTypeManager;
    }

    public int getQueueSize() {
        return this.queue.size();
    }

    public DocprocExecutor getExecutor() {
        return this.executor;
    }

    public ThreadPoolExecutor getThreadPoolExecutor() {
        return this.threadPool;
    }

    private void setExecutor(DocprocExecutor executor) {
        this.executor = executor;
    }

    public void setInService(boolean inService) {
        this.inService = inService;
    }

    public boolean isInService() {
        return this.inService;
    }

    public boolean isAcceptingNewProcessings() {
        return this.acceptingNewProcessings;
    }

    public void setAcceptingNewProcessings(boolean acceptingNewProcessings) {
        this.acceptingNewProcessings = acceptingNewProcessings;
    }

    public String getName() {
        return this.getId().stringValue();
    }

    public CallStack getCallStack() {
        DocprocExecutor ex = this.getExecutor();
        return ex == null ? null : ex.getCallStack();
    }

    public void setCallStack(CallStack stack) {
        DocprocExecutor ex = this.getExecutor() == null ? new DocprocExecutor(this.getName(), stack) : new DocprocExecutor(this.getExecutor(), stack);
        this.setExecutor(ex);
    }

    public void process(Processing processing, ProcessingEndpoint endp) {
        processing.setServiceName(this.getName());
        processing.setCallStack(new CallStack(this.getCallStack()));
        processing.setEndpoint(endp);
        this.addProcessing(processing);
    }

    public void process(Processing processing) {
        this.process(processing, null);
    }

    public void process(DocumentOperation documentOperation, ProcessingEndpoint endp) {
        this.addProcessing(new Processing(this.getName(), documentOperation, new CallStack(this.getCallStack()), endp));
    }

    public void process(DocumentOperation documentOperation) {
        this.process(documentOperation, null);
    }

    public void processDocumentOperations(List<DocumentOperation> documentOperations, ProcessingEndpoint endp) {
        this.addProcessing(Processing.createProcessingFromDocumentOperations(this.getName(), documentOperations, new CallStack(this.getCallStack()), endp));
    }

    public void processDocumentOperations(List<DocumentOperation> documentOperations) {
        this.processDocumentOperations(documentOperations, null);
    }

    private void addProcessing(Processing processing) {
        if (!this.isAcceptingNewProcessings()) {
            throw new IllegalStateException("Docproc service " + this.getName() + " is not accepting new incoming processings. Cannot add " + processing + " ");
        }
        if (!this.queue.offer(processing)) {
            throw new RejectedExecutionException("Docproc service " + this.getName() + " is busy, please try later");
        }
    }

    public boolean doWork() {
        try {
            return this.doWork(false);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean doWork(boolean blocking) throws InterruptedException {
        Processing processing = blocking ? this.queue.take() : this.queue.poll();
        if (processing == null) {
            return false;
        }
        if (!this.isInService()) {
            this.queue.add(processing);
            return false;
        }
        boolean remove = this.workOn(processing);
        if (!remove) {
            this.queue.add(processing);
        }
        return true;
    }

    public boolean doWorkBlocking() throws InterruptedException {
        return this.doWork(true);
    }

    boolean workOn(Processing processing) {
        DocumentProcessor.Progress progress;
        DocprocExecutor ex = this.getExecutor();
        if (ex == null) {
            throw new NoCallStackException();
        }
        try {
            progress = ex.process(processing);
        }
        catch (Exception e) {
            this.processingFailed(processing, processing + " failed", e);
            return true;
        }
        if (DocumentProcessor.Progress.DONE.equals(progress)) {
            ProcessingEndpoint recv = processing.getEndpoint();
            if (recv != null) {
                recv.processingDone(processing);
            }
            return true;
        }
        if (DocumentProcessor.Progress.FAILED.equals(progress)) {
            this.processingFailed(processing, processing + " failed at " + processing.callStack().getLastPopped(), null);
            return true;
        }
        if (DocumentProcessor.Progress.PERMANENT_FAILURE.equals(progress)) {
            this.processingFailed(processing, processing + " failed PERMANENTLY at " + processing.callStack().getLastPopped() + ", disabling processing service.", null);
            this.setInService(false);
            return true;
        }
        return false;
    }

    private void processingFailed(Processing processing, String errorMsg, Exception e) {
        if (e != null) {
            if (e instanceof HandledProcessingException) {
                errorMsg = (String)errorMsg + ". Error message: " + e.getMessage();
                log.log(Level.WARNING, (String)errorMsg);
                log.log(Level.FINE, "Chained exception:", e);
            } else {
                log.log(Level.WARNING, (String)errorMsg, e);
            }
        } else {
            log.log(Level.WARNING, (String)errorMsg);
        }
        ProcessingEndpoint recv = processing.getEndpoint();
        if (recv != null) {
            recv.processingFailed(processing, e);
        }
    }

    private class NoCallStackException
    extends RuntimeException {
        private NoCallStackException() {
        }
    }
}

