/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.docproc;

import com.yahoo.component.ComponentId;
import com.yahoo.docproc.Call;
import com.yahoo.docproc.DocumentProcessor;
import com.yahoo.docproc.jdisc.metric.NullMetric;
import com.yahoo.jdisc.Metric;
import com.yahoo.statistics.Statistics;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class CallStack {
    private String name;
    private final List<Call> elements = new LinkedList<Call>();
    private Call lastPopped = null;
    private final Metric metric;

    public CallStack() {
        this(new NullMetric());
    }

    public CallStack(String name) {
        this(name, (Metric)new NullMetric());
    }

    public CallStack(Metric metric) {
        this.name = null;
        this.metric = metric;
    }

    @Deprecated
    public CallStack(Statistics statistics, Metric metric) {
        this(metric);
    }

    @Deprecated
    public CallStack(String name, Statistics manager, Metric metric) {
        this(name, metric);
    }

    public CallStack(String name, Metric metric) {
        this.name = name;
        this.metric = metric;
    }

    public CallStack(CallStack stackToCopy) {
        this.name = stackToCopy.name;
        ListIterator<Call> i = stackToCopy.iterator();
        while (i.hasNext()) {
            Call callToCopy = (Call)i.next();
            this.elements.add((Call)callToCopy.clone());
        }
        this.metric = stackToCopy.metric;
    }

    public CallStack(String name, Collection<DocumentProcessor> docprocs, Metric metric) {
        this(name, metric);
        for (DocumentProcessor docproc : docprocs) {
            this.addLast(docproc);
        }
    }

    @Deprecated
    public CallStack(String name, Collection<DocumentProcessor> docprocs, Statistics manager, Metric metric) {
        this(name, docprocs, metric);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CallStack addNext(Call call) {
        this.elements.add(0, call);
        return this;
    }

    public CallStack addNext(DocumentProcessor processor) {
        return this.addNext(new Call(processor, this.name, this.metric));
    }

    public CallStack addNext(CallStack callStack) {
        this.elements.addAll(0, callStack.elements);
        return this;
    }

    public CallStack addLast(Call call) {
        this.elements.add(call);
        return this;
    }

    public CallStack addLast(DocumentProcessor processor) {
        return this.addLast(new Call(processor, this.name, this.metric));
    }

    public CallStack addLast(CallStack callStack) {
        this.elements.addAll(callStack.elements);
        return this;
    }

    public CallStack addBefore(Call before, Call call) {
        int insertPosition = this.elements.indexOf(before);
        if (insertPosition < 0) {
            this.addLast(call);
        } else {
            this.elements.add(insertPosition, call);
        }
        return this;
    }

    public CallStack addBefore(Call before, DocumentProcessor processor) {
        return this.addBefore(before, new Call(processor, this.name, this.metric));
    }

    public CallStack addBefore(Call before, CallStack callStack) {
        int insertPosition = this.elements.indexOf(before);
        if (insertPosition < 0) {
            this.addLast(callStack);
        } else {
            this.elements.addAll(insertPosition, callStack.elements);
        }
        return this;
    }

    public CallStack addAfter(Call after, Call call) {
        int insertPosition = this.elements.indexOf(after);
        if (insertPosition < 0) {
            this.addLast(call);
        } else {
            this.elements.add(insertPosition + 1, call);
        }
        return this;
    }

    public CallStack addAfter(Call after, DocumentProcessor processor) {
        return this.addAfter(after, new Call(processor, this.name, this.metric));
    }

    public CallStack addAfter(Call after, CallStack callStack) {
        int insertPosition = this.elements.indexOf(after);
        if (insertPosition < 0) {
            this.addLast(callStack);
        } else {
            this.elements.addAll(insertPosition + 1, callStack.elements);
        }
        return this;
    }

    public CallStack remove(Call call) {
        ListIterator<Call> i = this.iterator();
        while (i.hasNext()) {
            Call current = i.next();
            if (current != call) continue;
            i.remove();
        }
        return this;
    }

    public boolean contains(Call call) {
        ListIterator<Call> i = this.iterator();
        while (i.hasNext()) {
            Call current = i.next();
            if (current != call) continue;
            return true;
        }
        return false;
    }

    public Call findCall(ComponentId processorId) {
        ListIterator<Call> i = this.iterator();
        while (i.hasNext()) {
            Call call = (Call)i.next();
            if (!call.getDocumentProcessorId().equals((Object)processorId)) continue;
            return call;
        }
        return null;
    }

    public Call findCall(DocumentProcessor processor) {
        return this.findCall(processor.getId());
    }

    public Call pop() {
        if (this.elements.isEmpty()) {
            return null;
        }
        this.lastPopped = this.elements.remove(0);
        return this.lastPopped;
    }

    public Call peek() {
        if (this.elements.isEmpty()) {
            return null;
        }
        return this.elements.get(0);
    }

    public Call getLastPopped() {
        return this.lastPopped;
    }

    public void clear() {
        this.elements.clear();
    }

    public ListIterator<Call> iterator() {
        return this.elements.listIterator();
    }

    public int size() {
        return this.elements.size();
    }

    public String toString() {
        StringBuilder b = new StringBuilder("callstack");
        if (this.name != null) {
            b.append(" ");
            b.append(this.name);
        }
        b.append(":");
        ListIterator<Call> i = this.iterator();
        while (i.hasNext()) {
            b.append("\n");
            b.append("  ");
            b.append(((Call)i.next()).toString());
        }
        b.append("\n");
        return b.toString();
    }

    @Deprecated
    public Statistics getStatistics() {
        return null;
    }

    public Metric getMetric() {
        return this.metric;
    }
}

