/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.docproc.jdisc;

import com.yahoo.concurrent.DaemonThreadFactory;
import com.yahoo.docproc.jdisc.DocprocThreadManager;
import com.yahoo.docproc.jdisc.DocumentProcessingTask;
import com.yahoo.log.LogLevel;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DocprocThreadPoolExecutor
extends ThreadPoolExecutor {
    private static Logger log = Logger.getLogger(DocprocThreadPoolExecutor.class.getName());
    private DocprocThreadManager threadManager;

    public DocprocThreadPoolExecutor(int maxNumThreads, BlockingQueue<Runnable> queue, DocprocThreadManager threadMgr) {
        super(maxNumThreads > 0 ? maxNumThreads : Runtime.getRuntime().availableProcessors(), maxNumThreads > 0 ? maxNumThreads : 8192, 1L, TimeUnit.SECONDS, queue, (ThreadFactory)new DaemonThreadFactory("docproc-"));
        this.threadManager = threadMgr;
        this.allowCoreThreadTimeOut(false);
        log.log((Level)LogLevel.DEBUG, "Created docproc thread pool with " + super.getCorePoolSize() + " worker threads.");
    }

    @Override
    protected void beforeExecute(Thread thread, Runnable runnable) {
        this.threadManager.beforeExecute((DocumentProcessingTask)runnable);
    }

    @Override
    protected void afterExecute(Runnable runnable, Throwable throwable) {
        this.threadManager.afterExecute((DocumentProcessingTask)runnable);
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.threadManager.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        List<Runnable> list = super.shutdownNow();
        this.threadManager.shutdown();
        return list;
    }

    boolean isAboveLimit() {
        return this.threadManager.isAboveLimit();
    }
}

