/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.docproc.proxy;

import com.yahoo.docproc.Accesses;
import com.yahoo.docproc.DocumentOperationWrapper;
import com.yahoo.docproc.DocumentProcessor;
import com.yahoo.document.DataType;
import com.yahoo.document.Document;
import com.yahoo.document.DocumentId;
import com.yahoo.document.DocumentOperation;
import com.yahoo.document.DocumentPut;
import com.yahoo.document.DocumentType;
import com.yahoo.document.Field;
import com.yahoo.document.FieldPath;
import com.yahoo.document.datatypes.FieldPathIteratorHandler;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.Struct;
import com.yahoo.document.serialization.DocumentReader;
import com.yahoo.document.serialization.DocumentWriter;
import com.yahoo.document.serialization.FieldReader;
import com.yahoo.document.serialization.FieldWriter;
import com.yahoo.document.serialization.SerializationException;
import com.yahoo.document.serialization.XmlStream;
import com.yahoo.vespa.objects.Serializer;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ProxyDocument
extends Document
implements DocumentOperationWrapper {
    private final Map<String, String> fieldMap;
    private final Set<String> fieldsAllowed = new HashSet<String>();
    private final String docProcName;
    private Document doc;

    public ProxyDocument(DocumentProcessor docProc, Document doc, Map<String, String> fieldMap) {
        super(doc);
        if (((Object)((Object)docProc)).getClass().getAnnotation(Accesses.class) != null) {
            for (Accesses.Field field : ((Object)((Object)docProc)).getClass().getAnnotation(Accesses.class).value()) {
                String name = field.name();
                if (fieldMap != null && fieldMap.get(name) != null) {
                    name = fieldMap.get(name);
                }
                this.fieldsAllowed.add(name);
            }
        }
        this.fieldMap = fieldMap;
        this.docProcName = docProc.toString();
        this.doc = doc;
    }

    private void checkAccess(Field field) {
        if (!this.fieldsAllowed.isEmpty() && !this.fieldsAllowed.contains(field.getName())) {
            throw new IllegalArgumentException("Processor '" + this.docProcName + "' is not allowed to access field '" + field.getName() + "'.");
        }
    }

    public Field getField(String fieldName) {
        if (this.fieldMap != null && this.fieldMap.containsKey(fieldName)) {
            fieldName = this.fieldMap.get(fieldName);
        }
        FieldPath path = this.getFieldPath(fieldName);
        Field ret = path.get(path.size() - 1).getFieldRef();
        this.checkAccess(ret);
        return ret;
    }

    public FieldValue getFieldValue(String fieldName) {
        return this.getRecursiveValue(this.getFieldPath(fieldName));
    }

    public FieldValue getFieldValue(Field field) {
        return this.doc.getFieldValue(field);
    }

    public FieldValue setFieldValue(String fieldName, FieldValue fieldValue) {
        SetHandler handler = new SetHandler(fieldValue);
        FieldPath path = this.getFieldPath(fieldName);
        this.iterateNested(path, 0, handler);
        if (!handler.doModifyCalled) {
            throw new IllegalArgumentException("Field '" + fieldName + "' mapped by '" + path + "' was not found.");
        }
        return handler.prevVal;
    }

    public FieldValue setFieldValue(Field field, FieldValue fieldValue) {
        this.checkAccess(field);
        return this.doc.setFieldValue(field, fieldValue);
    }

    public FieldValue removeFieldValue(String fieldName) {
        RemoveHandler handler = new RemoveHandler();
        FieldPath path = this.getFieldPath(fieldName);
        this.iterateNested(path, 0, handler);
        if (!handler.doModifyCalled) {
            throw new IllegalArgumentException("Field '" + fieldName + "' mapped by '" + path + "' was not found.");
        }
        return handler.prevVal;
    }

    public FieldValue removeFieldValue(Field field) {
        this.checkAccess(field);
        return this.doc.removeFieldValue(field);
    }

    private FieldPath getFieldPath(String fieldName) {
        if (this.fieldMap != null && this.fieldMap.containsKey(fieldName)) {
            fieldName = this.fieldMap.get(fieldName);
        }
        this.checkAccess(new Field(fieldName));
        FieldPath path = FieldPath.newInstance((DataType)this.getDataType(), (String)fieldName);
        if (path == null || path.size() == 0) {
            throw new IllegalArgumentException("Malformed schema mapping '" + fieldName + "'.");
        }
        return path;
    }

    @Override
    public DocumentOperation getWrappedDocumentOperation() {
        return new DocumentPut((Document)this);
    }

    public boolean equals(Object o) {
        return this.doc.equals(o);
    }

    public String toString() {
        return this.doc.toString();
    }

    public int hashCode() {
        return this.doc.hashCode();
    }

    public Document clone() {
        return this.doc.clone();
    }

    public void clear() {
        this.doc.clear();
    }

    public Iterator<Map.Entry<Field, FieldValue>> iterator() {
        return this.doc.iterator();
    }

    public DocumentId getId() {
        return this.doc.getId();
    }

    public void setLastModified(Long lastModified) {
        this.doc.setLastModified(lastModified);
    }

    public Long getLastModified() {
        return this.doc.getLastModified();
    }

    public void setId(DocumentId id) {
        this.doc.setId(id);
    }

    public Struct getHeader() {
        return this.doc.getHeader();
    }

    public Struct getBody() {
        return null;
    }

    public void assign(Object o) {
        this.doc.assign(o);
    }

    public void setDataType(DataType type) {
        this.doc.setDataType(type);
    }

    public int getSerializedSize() throws SerializationException {
        return this.doc.getSerializedSize();
    }

    public void serialize(OutputStream out) throws SerializationException {
        this.doc.serialize(out);
    }

    protected void doSetFieldValue(Field field, FieldValue value) {
        super.doSetFieldValue(field, value);
    }

    public String toXML(String indent) {
        return this.doc.toXML(indent);
    }

    public String toXml() {
        return this.doc.toXml();
    }

    public void printXml(XmlStream xml) {
        this.doc.printXml(xml);
    }

    public String toJson() {
        return this.doc.toJson();
    }

    public void onSerialize(Serializer target) throws SerializationException {
        this.doc.onSerialize(target);
    }

    public DocumentType getDataType() {
        return this.doc.getDataType();
    }

    public int getFieldCount() {
        return this.doc.getFieldCount();
    }

    public void serialize(DocumentWriter writer) {
        this.doc.serialize(writer);
    }

    public void deserialize(DocumentReader reader) {
        this.doc.deserialize(reader);
    }

    public void serialize(Field field, FieldWriter writer) {
        this.doc.serialize(field, writer);
    }

    public void deserialize(Field field, FieldReader reader) {
        this.doc.deserialize(field, reader);
    }

    public int compareTo(FieldValue fieldValue) {
        return super.compareTo(fieldValue);
    }

    public FieldPathIteratorHandler.ModificationStatus iterateNested(FieldPath fieldPath, int pos, FieldPathIteratorHandler handler) {
        return this.doc.iterateNested(fieldPath, pos, handler);
    }

    public Document getDocument() {
        return this.doc;
    }

    private static class RemoveHandler
    extends FieldPathIteratorHandler {
        private boolean doModifyCalled = false;
        private FieldValue prevVal;

        private RemoveHandler() {
        }

        public boolean onComplex(FieldValue fieldVal) {
            return false;
        }

        public FieldPathIteratorHandler.ModificationStatus doModify(FieldValue fieldVal) {
            this.doModifyCalled = true;
            this.prevVal = fieldVal.clone();
            return FieldPathIteratorHandler.ModificationStatus.REMOVED;
        }
    }

    private static class SetHandler
    extends FieldPathIteratorHandler {
        private final FieldValue nextVal;
        private FieldValue prevVal;
        private boolean doModifyCalled = false;

        public SetHandler(FieldValue fieldValue) {
            this.nextVal = fieldValue;
        }

        public boolean onComplex(FieldValue fieldVal) {
            return false;
        }

        public boolean createMissingPath() {
            return true;
        }

        public FieldPathIteratorHandler.ModificationStatus doModify(FieldValue fieldVal) {
            this.doModifyCalled = true;
            this.prevVal = fieldVal.clone();
            fieldVal.assign((Object)this.nextVal);
            return FieldPathIteratorHandler.ModificationStatus.MODIFIED;
        }
    }
}

