/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.docproc;

import com.yahoo.docproc.Call;
import com.yahoo.docproc.CallStack;
import com.yahoo.docproc.DocumentProcessor;
import com.yahoo.docproc.Processing;
import com.yahoo.document.Document;
import com.yahoo.document.DocumentOperation;
import com.yahoo.document.DocumentPut;
import com.yahoo.document.json.JsonWriter;
import com.yahoo.jdisc.Metric;
import com.yahoo.statistics.Counter;
import com.yahoo.text.Utf8;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DocprocExecutor {
    private static final String METRIC_NAME_DOCUMENTS_PROCESSED = "documents_processed";
    private static final Logger log = Logger.getLogger(DocprocExecutor.class.getName());
    private final String name;
    private final String docCounterName;
    private final Counter docCounter;
    private final Metric metric;
    private Metric.Context context;
    private final CallStack callStack;

    public DocprocExecutor(String name, CallStack callStack) {
        this.name = name;
        String chainDimension = name;
        if (name != null) {
            chainDimension = name.replaceAll("[^\\p{Alnum}]", "_");
            this.docCounterName = "chain_" + name.replaceAll("[^\\p{Alnum}]", "_") + "_documents";
        } else {
            this.docCounterName = "chain_" + name + "_documents";
        }
        this.docCounter = new Counter(this.docCounterName, callStack.getStatistics(), false);
        this.metric = callStack.getMetric();
        this.callStack = callStack;
        this.callStack.setName(name);
        this.context = this.metric.createContext(Collections.singletonMap("chain", chainDimension));
    }

    public DocprocExecutor(DocprocExecutor oldExecutor, CallStack callStack) {
        this.name = oldExecutor.name;
        this.docCounterName = oldExecutor.docCounterName;
        this.docCounter = oldExecutor.docCounter;
        this.metric = oldExecutor.metric;
        this.context = oldExecutor.context;
        this.callStack = callStack;
    }

    public CallStack getCallStack() {
        return this.callStack;
    }

    public String getName() {
        return this.name;
    }

    private void incrementNumDocsProcessed(int num) {
        this.docCounter.increment((long)num);
        this.metric.add(this.docCounterName, (Number)num, null);
        this.metric.add(METRIC_NAME_DOCUMENTS_PROCESSED, (Number)num, this.context);
    }

    private void incrementNumDocsProcessed(Processing processing) {
        int increment = processing.getNumDocsToBeProcessed();
        if (increment != 0) {
            this.incrementNumDocsProcessed(increment);
        }
    }

    public DocumentProcessor.Progress process(Processing processing) {
        processing.setServiceName(this.getName());
        if (processing.callStack() == null) {
            processing.setCallStack(new CallStack(this.getCallStack()));
        }
        DocumentProcessor.Progress progress = DocumentProcessor.Progress.DONE;
        this.incrementNumDocsProcessed(processing);
        do {
            Call call;
            if ((call = processing.callStack().pop()) == null) {
                return progress;
            }
            progress = DocumentProcessor.Progress.DONE;
            progress = call.call(processing);
            if (log.isLoggable(Level.FINEST)) {
                this.logProgress(processing, progress, call);
            }
            if (!DocumentProcessor.Progress.LATER.equals(progress)) continue;
            processing.callStack().addNext(call);
            return progress;
        } while (DocumentProcessor.Progress.DONE.equals(progress));
        return progress;
    }

    private void logProgress(Processing processing, DocumentProcessor.Progress progress, Call call) {
        StringBuilder message = new StringBuilder();
        boolean first = true;
        message.append(call.getDocumentProcessorId()).append(" of class ").append(((Object)((Object)call.getDocumentProcessor())).getClass().getSimpleName()).append(" returned ").append(progress).append(" for the documents: [");
        for (DocumentOperation op : processing.getDocumentOperations()) {
            if (first) {
                first = false;
            } else {
                message.append(", ");
            }
            if (op instanceof DocumentPut) {
                message.append(Utf8.toString((byte[])JsonWriter.toByteArray((Document)((DocumentPut)op).getDocument())));
                continue;
            }
            message.append(op.toString());
        }
        message.append("]");
        log.log(Level.FINEST, message.toString());
    }

    public DocumentProcessor.Progress processUntilDone(Processing processing) {
        DocumentProcessor.Progress progress;
        while ((progress = this.process(processing)) instanceof DocumentProcessor.LaterProgress) {
            DocumentProcessor.LaterProgress later = (DocumentProcessor.LaterProgress)progress;
            try {
                Thread.sleep(later.getDelay());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        }
        return progress;
    }
}

