/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.docproc.proxy;

import com.yahoo.docproc.DocumentOperationWrapper;
import com.yahoo.document.Document;
import com.yahoo.document.DocumentId;
import com.yahoo.document.DocumentOperation;
import com.yahoo.document.DocumentType;
import com.yahoo.document.DocumentUpdate;
import com.yahoo.document.Field;
import com.yahoo.document.serialization.DocumentUpdateWriter;
import com.yahoo.document.update.FieldUpdate;
import java.util.List;
import java.util.Map;

public class ProxyDocumentUpdate
extends DocumentUpdate
implements DocumentOperationWrapper {
    private DocumentUpdate docU;
    private Map<String, String> fieldMap;

    public ProxyDocumentUpdate(DocumentUpdate docUpd, Map<String, String> fieldMap) {
        super(docUpd.getType(), docUpd.getId().toString() + "-schemamappedupdate");
        this.docU = docUpd;
        this.fieldMap = fieldMap;
    }

    public DocumentType getDocumentType() {
        return this.docU.getDocumentType();
    }

    public FieldUpdate getFieldUpdate(Field field) {
        return this.getFieldUpdate(field.getName());
    }

    public FieldUpdate getFieldUpdate(int index) {
        return this.docU.getFieldUpdate(index);
    }

    public FieldUpdate getFieldUpdate(String fieldName) {
        String mapped = this.fieldMap.get(fieldName);
        if (mapped == null) {
            return this.docU.getFieldUpdate(fieldName);
        }
        return this.docU.getFieldUpdate(mapped);
    }

    public List<FieldUpdate> getFieldUpdates() {
        return this.docU.getFieldUpdates();
    }

    public DocumentId getId() {
        return this.docU.getId();
    }

    public DocumentType getType() {
        return this.docU.getType();
    }

    public DocumentUpdate addFieldUpdate(FieldUpdate fieldUpdate) {
        return this.docU.addFieldUpdate(fieldUpdate);
    }

    public DocumentUpdate applyTo(Document doc) {
        return this.docU.applyTo(doc);
    }

    public boolean equals(Object o) {
        return this.docU.equals(o);
    }

    public int hashCode() {
        return this.docU.hashCode();
    }

    public void serialize(DocumentUpdateWriter data) {
        this.docU.serialize(data);
    }

    public int size() {
        return this.docU.size();
    }

    public String toString() {
        return this.docU.toString();
    }

    @Override
    public DocumentOperation getWrappedDocumentOperation() {
        DocumentUpdate innermostDocOp = this.docU;
        while (innermostDocOp instanceof DocumentOperationWrapper) {
            innermostDocOp = ((DocumentOperationWrapper)innermostDocOp).getWrappedDocumentOperation();
        }
        return innermostDocOp;
    }
}

