/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.docproc.proxy;

import com.yahoo.collections.Pair;
import com.yahoo.config.docproc.SchemamappingConfig;
import com.yahoo.config.subscription.ConfigSubscriber;
import java.util.HashMap;
import java.util.Map;

public class SchemaMap
implements ConfigSubscriber.SingleSubscriber<SchemamappingConfig> {
    private final ConfigSubscriber subscriber;
    private Map<SchemaMapKey, String> fields = new HashMap<SchemaMapKey, String>();

    void addMapping(String chain, String docproc, String doctype, String inDocument, String inProcessor) {
        this.fields.put(new SchemaMapKey(chain, docproc, doctype, inDocument), inProcessor);
    }

    public SchemaMap(String configid) {
        this.subscriber = new ConfigSubscriber();
        if (configid != null) {
            this.subscriber.subscribe((ConfigSubscriber.SingleSubscriber)this, SchemamappingConfig.class, configid);
        }
    }

    public SchemaMap() {
        this(null);
    }

    public void configure(SchemamappingConfig config) {
        if (config == null) {
            return;
        }
        this.fields.clear();
        for (SchemamappingConfig.Fieldmapping m : config.fieldmapping()) {
            SchemaMapKey key = new SchemaMapKey(m.chain(), m.docproc(), "".equals(m.doctype()) ? null : m.doctype(), m.indocument());
            this.fields.put(key, m.inprocessor());
        }
    }

    public Map<Pair<String, String>, String> chainMap(String chain, String docproc) {
        HashMap<Pair<String, String>, String> ret = new HashMap<Pair<String, String>, String>();
        for (Map.Entry<SchemaMapKey, String> e : this.fields.entrySet()) {
            SchemaMapKey key = e.getKey();
            if (!key.getChain().equals(chain) || !key.getDocproc().equals(docproc)) continue;
            ret.put((Pair<String, String>)new Pair((Object)key.getDoctype(), (Object)e.getValue()), key.getInDocument());
        }
        return ret;
    }

    class SchemaMapKey {
        private final String chain;
        private final String docproc;
        private final String doctype;
        private final String inDocument;

        public SchemaMapKey(String chain, String docproc, String doctype, String from) {
            this.chain = chain;
            this.docproc = docproc;
            this.doctype = doctype;
            this.inDocument = from;
            if (chain == null) {
                throw new IllegalArgumentException("'chain' cannot be null in schema map.");
            }
            if (docproc == null) {
                throw new IllegalArgumentException("'docproc' cannot be null in schema map.");
            }
            if (from == null) {
                throw new IllegalArgumentException("'from' cannot be null in schema map.");
            }
        }

        public String getChain() {
            return this.chain;
        }

        public String getDocproc() {
            return this.docproc;
        }

        public String getDoctype() {
            return this.doctype;
        }

        public String getInDocument() {
            return this.inDocument;
        }

        private boolean equalType(SchemaMapKey other) {
            if (this.doctype == null) {
                return other.getDoctype() == null;
            }
            return this.doctype.equals(other.getDoctype());
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof SchemaMapKey)) {
                return false;
            }
            SchemaMapKey other = (SchemaMapKey)obj;
            return other.getChain().equals(this.chain) && other.getDocproc().equals(this.docproc) && other.getInDocument().equals(this.inDocument) && this.equalType(other);
        }

        public int hashCode() {
            return this.chain.hashCode() + this.docproc.hashCode() + (this.doctype != null ? this.doctype.hashCode() : 0) + this.inDocument.hashCode();
        }
    }
}

