/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.defaults;

import java.util.Optional;
import java.util.logging.Logger;

public class Defaults {
    private static final Logger log = Logger.getLogger(Defaults.class.getName());
    private static final Defaults defaults = new Defaults();
    private final String vespaHome = Defaults.findVespaHome("/opt/vespa");
    private final String vespaUser = Defaults.findVespaUser("vespa");
    private final String vespaHost = Defaults.findVespaHostname("localhost");
    private final String temporaryApplicationStorage = this.underVespaHome("var/vespa/application");
    private final int vespaWebServicePort = Defaults.findWebServicePort(8080);
    private final int vespaPortBase = Defaults.findVespaPortBase(19000);
    private final int vespaPortConfigServerRpc = Defaults.findConfigServerPort(this.vespaPortBase + 70);
    private final int vespaPortConfigServerHttp = this.vespaPortConfigServerRpc + 1;
    private final int vespaPortConfigProxyRpc = Defaults.findConfigProxyPort(this.vespaPortBase + 90);

    private Defaults() {
    }

    private static String findVespaHome(String defHome) {
        Optional<String> vespaHomeEnv = Optional.ofNullable(System.getenv("VESPA_HOME"));
        if (!vespaHomeEnv.isPresent() || vespaHomeEnv.get().trim().isEmpty()) {
            log.info("VESPA_HOME not set, using " + defHome);
            return defHome;
        }
        String vespaHome = vespaHomeEnv.get().trim();
        if (vespaHome.endsWith("/")) {
            int sz = vespaHome.length() - 1;
            vespaHome = vespaHome.substring(0, sz);
        }
        return vespaHome;
    }

    private static String findVespaHostname(String defHost) {
        Optional<String> vespaHostEnv = Optional.ofNullable(System.getenv("VESPA_HOSTNAME"));
        if (vespaHostEnv.isPresent() && !vespaHostEnv.get().trim().isEmpty()) {
            return vespaHostEnv.get().trim();
        }
        return defHost;
    }

    private static String findVespaUser(String defUser) {
        Optional<String> vespaUserEnv = Optional.ofNullable(System.getenv("VESPA_USER"));
        if (!vespaUserEnv.isPresent()) {
            log.fine("VESPA_USER not set, using " + defUser);
            return defUser;
        }
        return vespaUserEnv.get().trim();
    }

    private static int findPort(String varName, int defaultPort) {
        Optional<String> port = Optional.ofNullable(System.getenv(varName));
        if (!port.isPresent() || port.get().trim().isEmpty()) {
            log.fine(varName + " not set, using " + defaultPort);
            return defaultPort;
        }
        try {
            return Integer.parseInt(port.get());
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("must be an integer, was '" + port.get() + "'");
        }
    }

    private static int findVespaPortBase(int defaultPort) {
        return Defaults.findPort("VESPA_PORT_BASE", defaultPort);
    }

    private static int findConfigServerPort(int defaultPort) {
        return Defaults.findPort("port_configserver_rpc", defaultPort);
    }

    private static int findConfigProxyPort(int defaultPort) {
        return Defaults.findPort("port_configproxy_rpc", defaultPort);
    }

    private static int findWebServicePort(int defaultPort) {
        return Defaults.findPort("VESPA_WEB_SERVICE_PORT", defaultPort);
    }

    public String vespaUser() {
        return this.vespaUser;
    }

    public String vespaHostname() {
        return this.vespaHost;
    }

    public String temporaryApplicationStorage() {
        return this.temporaryApplicationStorage;
    }

    public String vespaHome() {
        return this.vespaHome;
    }

    public String underVespaHome(String path) {
        if (path.startsWith("/")) {
            return path;
        }
        if (path.startsWith("./")) {
            return path;
        }
        return this.vespaHome() + "/" + path;
    }

    public int vespaWebServicePort() {
        return this.vespaWebServicePort;
    }

    public int vespaPortBase() {
        return this.vespaPortBase;
    }

    public int vespaConfigServerRpcPort() {
        return this.vespaPortConfigServerRpc;
    }

    public int vespaConfigServerHttpPort() {
        return this.vespaPortConfigServerHttp;
    }

    public int vespaConfigProxyRpcPort() {
        return this.vespaPortConfigProxyRpc;
    }

    public static Defaults getDefaults() {
        return defaults;
    }
}

