/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.defaults;

import java.util.Optional;
import java.util.logging.Logger;

public class Defaults {
    private static final Logger log = Logger.getLogger(Defaults.class.getName());
    private static final Defaults defaults = new Defaults();
    private final String vespaHome = Defaults.findVespaHome();
    private final String vespaUser = Defaults.findVespaUser();
    private final String vespaHost = Defaults.findVespaHostname();
    private final int vespaWebServicePort = Defaults.findVespaWebServicePort();
    private final int vespaPortBase;

    private Defaults() {
        this.vespaPortBase = 19000;
    }

    private static String findVespaHome() {
        Optional<String> vespaHomeEnv = Optional.ofNullable(System.getenv("VESPA_HOME"));
        if (!vespaHomeEnv.isPresent() || vespaHomeEnv.get().trim().isEmpty()) {
            log.info("VESPA_HOME not set, using /opt/vespa");
            return "/opt/vespa";
        }
        String vespaHome = vespaHomeEnv.get().trim();
        if (vespaHome.endsWith("/")) {
            int sz = vespaHome.length() - 1;
            vespaHome = vespaHome.substring(0, sz);
        }
        return vespaHome;
    }

    private static String findVespaHostname() {
        Optional<String> vespaHostEnv = Optional.ofNullable(System.getenv("VESPA_HOSTNAME"));
        if (vespaHostEnv.isPresent() && !vespaHostEnv.get().trim().isEmpty()) {
            return vespaHostEnv.get().trim();
        }
        return "localhost";
    }

    private static String findVespaUser() {
        Optional<String> vespaUserEnv = Optional.ofNullable(System.getenv("VESPA_USER"));
        if (!vespaUserEnv.isPresent()) {
            log.fine("VESPA_USER not set, using vespa");
            return "vespa";
        }
        return vespaUserEnv.get().trim();
    }

    private static int findVespaWebServicePort() {
        Optional<String> vespaWebServicePortString = Optional.ofNullable(System.getenv("VESPA_WEB_SERVICE_PORT"));
        if (!vespaWebServicePortString.isPresent() || vespaWebServicePortString.get().trim().isEmpty()) {
            log.info("VESPA_WEB_SERVICE_PORT not set, using 8080");
            return 8080;
        }
        try {
            return Integer.parseInt(vespaWebServicePortString.get());
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("VESPA_WEB_SERVICE_PORT must be an integer, was '" + vespaWebServicePortString.get() + "'");
        }
    }

    public String vespaUser() {
        return this.vespaUser;
    }

    public String vespaHostname() {
        return this.vespaHost;
    }

    public String vespaHome() {
        return this.vespaHome;
    }

    public String underVespaHome(String path) {
        if (path.startsWith("/")) {
            return path;
        }
        if (path.startsWith("./")) {
            return path;
        }
        return this.vespaHome() + "/" + path;
    }

    public int vespaWebServicePort() {
        return this.vespaWebServicePort;
    }

    public int vespaPortBase() {
        return this.vespaPortBase;
    }

    public static Defaults getDefaults() {
        return defaults;
    }
}

