/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.spifly.repackaged.spifly;

import com.yahoo.vespa.spifly.repackaged.aQute.bnd.header.Attrs;
import com.yahoo.vespa.spifly.repackaged.aQute.bnd.header.OSGiHeader;
import com.yahoo.vespa.spifly.repackaged.aQute.bnd.header.Parameters;
import com.yahoo.vespa.spifly.repackaged.aQute.bnd.stream.MapStream;
import com.yahoo.vespa.spifly.repackaged.aQute.libg.glob.Glob;
import com.yahoo.vespa.spifly.repackaged.spifly.BaseActivator;
import com.yahoo.vespa.spifly.repackaged.spifly.ConsumerHeaderProcessor;
import com.yahoo.vespa.spifly.repackaged.spifly.ProviderPrototypeServiceFactory;
import com.yahoo.vespa.spifly.repackaged.spifly.ProviderServiceFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServicePermission;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.util.tracker.BundleTrackerCustomizer;

public class ProviderBundleTrackerCustomizer
implements BundleTrackerCustomizer {
    private static final String METAINF_SERVICES = "META-INF/services";
    private static final List<String> MERGE_HEADERS = Arrays.asList("Import-Package", "Require-Bundle", "Export-Package", "Provide-Capability", "Require-Capability");
    final BaseActivator activator;
    final Bundle spiBundle;

    public ProviderBundleTrackerCustomizer(BaseActivator activator, Bundle spiBundle) {
        this.activator = activator;
        this.spiBundle = spiBundle;
    }

    public List<ServiceRegistration> addingBundle(Bundle bundle, BundleEvent event) {
        BundleRevision bundleRevision = (BundleRevision)bundle.adapt(BundleRevision.class);
        if (bundle.equals(this.spiBundle) || bundleRevision != null && (bundleRevision.getTypes() & 1) == 1) {
            return null;
        }
        this.log(Level.FINE, "Bundle Considered for SPI providers: " + bundle.getSymbolicName());
        DiscoveryMode discoveryMode = DiscoveryMode.SERVICELOADER_CAPABILITIES;
        List<String> providedServices = null;
        HashMap<String, Object> customAttributes = new HashMap<String, Object>();
        if (bundle.getHeaders().get("Require-Capability") != null) {
            try {
                providedServices = this.readServiceLoaderMediatorCapabilityMetadata(bundle, customAttributes);
            }
            catch (InvalidSyntaxException e) {
                this.log(Level.FINE, "Unable to read capabilities from bundle " + bundle, e);
            }
        }
        String spiProviderHeader = this.getHeaderFromBundleOrFragment(bundle, "SPI-Provider");
        if (providedServices == null && spiProviderHeader != null) {
            String header = spiProviderHeader.trim();
            providedServices = "*".equals(header) ? new ArrayList<String>() : Stream.of(header.split(",")).map(String::trim).collect(Collectors.toList());
            discoveryMode = DiscoveryMode.SPI_PROVIDER_HEADER;
        }
        List<URL> serviceFileURLs = null;
        if (providedServices == null) {
            Map.Entry<List<String>, List<URL>> autoServices = this.getFromAutoProviderProperty(bundle, customAttributes);
            providedServices = autoServices.getKey();
            serviceFileURLs = autoServices.getValue();
            discoveryMode = DiscoveryMode.AUTO_PROVIDERS_PROPERTY;
        }
        if (providedServices == null) {
            this.log(Level.FINE, "No provided SPI services. Skipping bundle: " + bundle.getSymbolicName());
            return null;
        }
        this.log(Level.FINE, "Examining bundle for SPI provider: " + bundle.getSymbolicName());
        for (String serviceType : providedServices) {
            this.activator.registerProviderBundle(serviceType, bundle, customAttributes);
        }
        if (serviceFileURLs == null) {
            serviceFileURLs = this.getServiceFileUrls(bundle);
        }
        ArrayList<ServiceRegistration> registrations = new ArrayList<ServiceRegistration>();
        for (ServiceDetails details : this.collectServiceDetails(bundle, serviceFileURLs, discoveryMode)) {
            if (providedServices.size() > 0 && !providedServices.contains(details.serviceType)) continue;
            try {
                Class cls = bundle.loadClass(details.instanceType);
                this.log(Level.FINE, "Loaded SPI provider: " + cls);
                if (details.properties != null) {
                    ServiceRegistration reg = null;
                    ProviderServiceFactory instance = details.properties.containsKey("service.scope") && "prototype".equalsIgnoreCase(String.valueOf(details.properties.get("service.scope"))) ? new ProviderPrototypeServiceFactory(cls) : new ProviderServiceFactory(cls);
                    SecurityManager sm = System.getSecurityManager();
                    if (sm != null) {
                        if (bundle.hasPermission((Object)new ServicePermission(details.serviceType, "register"))) {
                            reg = bundle.getBundleContext().registerService(details.serviceType, (Object)instance, (Dictionary)details.properties);
                        } else {
                            this.log(Level.FINE, "Bundle " + bundle + " does not have the permission to register services of type: " + details.serviceType);
                        }
                    } else {
                        reg = bundle.getBundleContext().registerService(details.serviceType, (Object)instance, (Dictionary)details.properties);
                    }
                    if (reg != null) {
                        registrations.add(reg);
                        this.log(Level.FINE, "Registered service: " + reg);
                    }
                }
                this.activator.registerProviderBundle(details.serviceType, bundle, details.properties);
                this.log(Level.INFO, "Registered provider " + details.instanceType + " of service " + details.serviceType + " in bundle " + bundle.getSymbolicName());
            }
            catch (Exception e) {
                this.log(Level.FINE, "Could not load provider " + details.instanceType + " of service " + details.serviceType, e);
            }
        }
        return registrations;
    }

    private List<ServiceDetails> collectServiceDetails(Bundle bundle, List<URL> serviceFileURLs, DiscoveryMode discoveryMode) {
        ArrayList<ServiceDetails> serviceDetails = new ArrayList<ServiceDetails>();
        for (URL serviceFileURL : serviceFileURLs) {
            this.log(Level.FINE, "Found SPI resource: " + serviceFileURL);
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(serviceFileURL.openStream()));
                String className = null;
                while ((className = reader.readLine()) != null) {
                    try {
                        Hashtable<Object, Object> properties;
                        if ((className = className.trim()).length() == 0 || className.startsWith("#")) continue;
                        String serviceFile = serviceFileURL.toExternalForm();
                        int idx = serviceFile.lastIndexOf(47);
                        String registrationClassName = className;
                        if (serviceFile.length() > idx) {
                            registrationClassName = serviceFile.substring(idx + 1);
                        }
                        if ((properties = discoveryMode == DiscoveryMode.SPI_PROVIDER_HEADER ? new Hashtable<String, Long>() : (discoveryMode == DiscoveryMode.AUTO_PROVIDERS_PROPERTY ? this.activator.getAutoProviderInstructions().map(Parameters::stream).orElseGet(MapStream::empty).filterKey(i -> Glob.toPattern(i).asPredicate().test(bundle.getSymbolicName())).values().findFirst().map(Hashtable::new).orElseGet(() -> new Hashtable()) : this.findServiceRegistrationProperties(bundle, registrationClassName, className))) != null) {
                            properties.put("serviceloader.mediator", this.spiBundle.getBundleId());
                            properties.put(".com.yahoo.vespa.spifly.repackaged.spifly.provider.implclass", (Long)((Object)className));
                            properties.put(".com.yahoo.vespa.spifly.repackaged.spifly.provider.discovery.mode", (Long)((Object)discoveryMode.toString()));
                        }
                        serviceDetails.add(new ServiceDetails(registrationClassName, className, properties));
                    }
                    catch (Exception e) {
                        this.log(Level.FINE, "Could not load SPI implementation referred from " + serviceFileURL, e);
                    }
                }
            }
            catch (IOException e) {
                this.log(Level.FINE, "Could not read SPI metadata from " + serviceFileURL, e);
            }
        }
        return serviceDetails;
    }

    private Map.Entry<List<String>, List<URL>> getFromAutoProviderProperty(Bundle bundle, Map<String, Object> customAttributes) {
        return this.activator.getAutoProviderInstructions().map(Parameters::stream).orElseGet(MapStream::empty).filterKey(i -> Glob.toPattern(i).asPredicate().test(bundle.getSymbolicName())).values().findFirst().map(un -> {
            List<URL> serviceFileURLs = this.getServiceFileUrls(bundle);
            List<ServiceDetails> collectServiceDetails = this.collectServiceDetails(bundle, serviceFileURLs, DiscoveryMode.AUTO_PROVIDERS_PROPERTY);
            collectServiceDetails.stream().map(ServiceDetails::getProperties).filter(Objects::nonNull).forEach(hashtable -> hashtable.forEach(customAttributes::put));
            List providedServices = collectServiceDetails.stream().map(ServiceDetails::getServiceType).collect(Collectors.toList());
            return new AbstractMap.SimpleImmutableEntry(providedServices, serviceFileURLs);
        }).orElseGet(() -> new AbstractMap.SimpleImmutableEntry<Object, Object>(null, null));
    }

    private List<URL> getServiceFileUrls(Bundle bundle) {
        Object bcp;
        ArrayList<URL> serviceFileURLs = new ArrayList<URL>();
        Enumeration entries = bundle.findEntries(METAINF_SERVICES, "*", false);
        if (entries != null) {
            serviceFileURLs.addAll(Collections.list(entries));
        }
        if ((bcp = bundle.getHeaders().get("Bundle-ClassPath")) instanceof String) {
            for (String entry : ((String)bcp).split(",")) {
                URL url;
                if ((entry = entry.trim()).equals(".") || (url = bundle.getResource(entry)) == null) continue;
                serviceFileURLs.addAll(this.getMetaInfServiceURLsFromJar(url));
            }
        }
        return serviceFileURLs;
    }

    private String getHeaderFromBundleOrFragment(Bundle bundle, String headerName) {
        return this.getHeaderFromBundleOrFragment(bundle, headerName, null);
    }

    private String getHeaderFromBundleOrFragment(Bundle bundle, String headerName, String matchString) {
        BundleWiring wiring;
        Parameters headerParameters = new Parameters((String)bundle.getHeaders().get(headerName));
        if (this.matches(headerParameters.toString(), matchString) && !MERGE_HEADERS.contains(headerName)) {
            return headerParameters.isEmpty() ? null : headerParameters.toString();
        }
        BundleRevision rev = (BundleRevision)bundle.adapt(BundleRevision.class);
        if (rev != null && (wiring = rev.getWiring()) != null) {
            for (BundleWire wire : wiring.getProvidedWires("osgi.wiring.host")) {
                Bundle fragment = wire.getRequirement().getRevision().getBundle();
                Parameters fragmentParameters = new Parameters((String)fragment.getHeaders().get(headerName));
                if (MERGE_HEADERS.contains(headerName)) {
                    headerParameters.mergeWith(fragmentParameters, false);
                } else {
                    headerParameters = fragmentParameters;
                }
                if (!this.matches(headerParameters.toString(), matchString)) continue;
                return headerParameters.toString();
            }
        }
        return headerParameters.isEmpty() ? null : headerParameters.toString();
    }

    private boolean matches(String val, String matchString) {
        if (val == null) {
            return false;
        }
        if (matchString == null) {
            return true;
        }
        int idx = val.indexOf(matchString);
        return idx >= 0;
    }

    private List<String> readServiceLoaderMediatorCapabilityMetadata(Bundle bundle, Map<String, Object> customAttributes) throws InvalidSyntaxException {
        String requirementHeader = this.getHeaderFromBundleOrFragment(bundle, "Require-Capability", "osgi.serviceloader");
        if (requirementHeader == null) {
            return null;
        }
        Parameters requirements = OSGiHeader.parseHeader(requirementHeader);
        Map.Entry<String, ? extends Map<String, String>> extenderRequirement = ConsumerHeaderProcessor.findRequirement(requirements, "osgi.extender", "osgi.serviceloader.registrar");
        if (extenderRequirement == null) {
            return null;
        }
        String capabilityHeader = this.getHeaderFromBundleOrFragment(bundle, "Provide-Capability", "osgi.serviceloader");
        Parameters capabilities = capabilityHeader == null ? new Parameters() : OSGiHeader.parseHeader(capabilityHeader);
        ArrayList<String> serviceNames = new ArrayList<String>();
        for (Map.Entry<String, ? extends Map<String, String>> serviceLoaderCapability : ConsumerHeaderProcessor.findAllMetadata(capabilities, "osgi.serviceloader")) {
            for (Map.Entry<String, String> entry : serviceLoaderCapability.getValue().entrySet()) {
                if ("osgi.serviceloader".equals(entry.getKey())) {
                    serviceNames.add(entry.getValue().trim());
                    continue;
                }
                if ("register:".equals(entry.getKey()) && entry.getValue().equals("")) continue;
                customAttributes.put(entry.getKey(), entry.getValue());
            }
        }
        return serviceNames;
    }

    private Hashtable<String, Object> findServiceRegistrationProperties(Bundle bundle, String spiName, String implName) {
        String capabilityHeader = this.getHeaderFromBundleOrFragment(bundle, "Provide-Capability");
        if (capabilityHeader == null) {
            return null;
        }
        Parameters capabilities = OSGiHeader.parseHeader(capabilityHeader.toString());
        for (Map.Entry<String, Attrs> entry : capabilities.entrySet()) {
            String key = ConsumerHeaderProcessor.removeDuplicateMarker(entry.getKey());
            Attrs attrs = entry.getValue();
            if (!"osgi.serviceloader".equals(key) || !attrs.containsKey("osgi.serviceloader") || !attrs.get("osgi.serviceloader").equals(spiName) || attrs.containsKey("register:") && !attrs.get("register:").equals(implName)) continue;
            Hashtable<String, Object> properties = new Hashtable<String, Object>();
            for (Map.Entry<String, String> prop : attrs.entrySet()) {
                if ("osgi.serviceloader".equals(prop.getKey()) || "register:".equals(prop.getKey()) || key.startsWith(".")) continue;
                properties.put(prop.getKey(), prop.getValue());
            }
            return properties;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<URL> getMetaInfServiceURLsFromJar(URL url) {
        ArrayList<URL> urls = new ArrayList<URL>();
        try (JarInputStream jis = null;){
            jis = new JarInputStream(url.openStream());
            JarEntry je = null;
            while ((je = jis.getNextJarEntry()) != null) {
                if (!je.getName().startsWith(METAINF_SERVICES) || je.getName().length() <= METAINF_SERVICES.length() + 1) continue;
                urls.add(new URL("jar:" + url + "!/" + je.getName()));
            }
        }
        catch (IOException e) {
            this.log(Level.FINE, "Problem opening embedded jar file: " + url, e);
        }
        return urls;
    }

    public void modifiedBundle(Bundle bundle, BundleEvent event, Object registrations) {
    }

    public void removedBundle(Bundle bundle, BundleEvent event, Object registrations) {
        this.activator.unregisterProviderBundle(bundle);
        if (registrations == null) {
            return;
        }
        for (ServiceRegistration reg : (List)registrations) {
            try {
                reg.unregister();
                this.log(Level.FINE, "Unregistered: " + reg);
            }
            catch (IllegalStateException illegalStateException) {}
        }
    }

    private void log(Level level, String message) {
        this.activator.log(level, message);
    }

    private void log(Level level, String message, Throwable th) {
        this.activator.log(level, message, th);
    }

    class ServiceDetails {
        private final String instanceType;
        private final Hashtable<String, Object> properties;
        private final String serviceType;

        public ServiceDetails(String serviceType, String instanceType, Hashtable<String, Object> properties) {
            this.serviceType = serviceType;
            this.instanceType = instanceType;
            this.properties = properties;
        }

        public String getInstanceType() {
            return this.instanceType;
        }

        public Hashtable<String, Object> getProperties() {
            return this.properties;
        }

        public String getServiceType() {
            return this.serviceType;
        }

        public String toString() {
            return String.format("ServiceDetails [serviceType=\"%s\", instanceType=\"%s\", properties=%s]", this.getServiceType(), this.getInstanceType(), this.getProperties());
        }
    }

    static enum DiscoveryMode {
        SPI_PROVIDER_HEADER,
        AUTO_PROVIDERS_PROPERTY,
        SERVICELOADER_CAPABILITIES;

    }
}

