/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.spifly.repackaged.aQute.libg.glob;

import com.yahoo.vespa.spifly.repackaged.aQute.libg.glob.Glob;
import java.util.regex.Pattern;

public class AntGlob
extends Glob {
    public static final AntGlob ALL = new AntGlob("**");
    private static final String SLASHY = "[\\\\/]";
    private static final String NOT_SLASHY = "[^\\\\/]";

    public AntGlob(String globString) {
        this(globString, 0);
    }

    public AntGlob(String globString, int flags) {
        super(globString, AntGlob.toPattern(globString, flags));
    }

    public static Pattern toPattern(String line) {
        return AntGlob.toPattern(line, 0);
    }

    public static Pattern toPattern(String line, int flags) {
        line = line.trim();
        int strLen = line.length();
        StringBuilder sb = new StringBuilder(strLen << 2);
        char previousChar = '\u0000';
        for (int i = 0; i < strLen; ++i) {
            char currentChar = line.charAt(i);
            switch (currentChar) {
                case '*': {
                    int k;
                    int j;
                    if ((i == 0 || AntGlob.isSlashy(previousChar)) && (j = i + 1) < strLen && line.charAt(j) == '*' && ((k = j + 1) == strLen || AntGlob.isSlashy(line.charAt(k)))) {
                        if (i == 0 && k < strLen) {
                            sb.append("(?:.*[\\\\/]|)");
                            i = k;
                            break;
                        }
                        if (i > 1) {
                            sb.setLength(sb.length() - SLASHY.length());
                            sb.append("(?:[\\\\/].*|)");
                            i = j;
                            break;
                        }
                        sb.append(".*");
                        i = j;
                        break;
                    }
                    sb.append("[^\\\\/]*");
                    break;
                }
                case '?': {
                    sb.append(NOT_SLASHY);
                    break;
                }
                case '/': 
                case '\\': {
                    if (i + 1 == strLen) {
                        sb.append("(?:[\\\\/].*|)");
                        break;
                    }
                    sb.append(SLASHY);
                    break;
                }
                case '$': 
                case '(': 
                case ')': 
                case '+': 
                case '.': 
                case '[': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    sb.append('\\');
                }
                default: {
                    sb.append(currentChar);
                }
            }
            previousChar = currentChar;
        }
        return Pattern.compile(sb.toString(), flags);
    }

    private static boolean isSlashy(char c) {
        return c == '/' || c == '\\';
    }
}

