/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.statistics;

import com.yahoo.component.ComponentId;
import com.yahoo.component.chain.dependencies.Before;
import com.yahoo.prelude.Ping;
import com.yahoo.prelude.Pong;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.cluster.PingableSearcher;
import com.yahoo.search.searchchain.Execution;
import com.yahoo.search.statistics.TimeTracker;
import com.yahoo.search.statistics.TimingSearcherConfig;
import com.yahoo.statistics.Statistics;
import com.yahoo.statistics.Value;

@Before(value={"rawQuery"})
@Deprecated
public class TimingSearcher
extends PingableSearcher {
    private Value measurements;
    private final boolean measurePing;
    private final boolean measureSearch;
    private final boolean measureFill;
    private static final Parameters defaultParameters = new Parameters(null, TimeTracker.Activity.SEARCH);

    TimingSearcher(ComponentId id, Parameters setUp, Statistics manager) {
        super(id);
        String eventName;
        if (setUp == null) {
            setUp = defaultParameters;
        }
        if ((eventName = setUp.eventName) == null || "".equals(eventName)) {
            eventName = id.getName();
        }
        this.measurements = new Value(eventName, manager, new Value.Parameters().setNameExtension(Boolean.valueOf(true)).setLogMax(Boolean.valueOf(true)).setLogMin(Boolean.valueOf(true)).setLogMean(Boolean.valueOf(true)).setLogSum(Boolean.valueOf(true)).setLogInsertions(Boolean.valueOf(true)).setAppendChar(Character.valueOf('_')));
        this.measurePing = setUp.pathToSample == TimeTracker.Activity.PING;
        this.measureSearch = setUp.pathToSample == TimeTracker.Activity.SEARCH;
        this.measureFill = setUp.pathToSample == TimeTracker.Activity.FILL;
    }

    public TimingSearcher(ComponentId id, TimingSearcherConfig config, Statistics manager) {
        this(id, TimingSearcher.buildParameters(config, id.getName()), manager);
    }

    private static Parameters buildParameters(TimingSearcherConfig config, String searcherName) {
        for (int i = 0; i < config.timer().size(); ++i) {
            TimingSearcherConfig.Timer t = config.timer(i);
            if (!t.name().equals(searcherName)) continue;
            return TimingSearcher.buildParameters(t);
        }
        return null;
    }

    private static Parameters buildParameters(TimingSearcherConfig.Timer t) {
        TimingSearcherConfig.Timer.Measure.Enum toSample = t.measure();
        TimeTracker.Activity m = toSample == TimingSearcherConfig.Timer.Measure.FILL ? TimeTracker.Activity.FILL : (toSample == TimingSearcherConfig.Timer.Measure.PING ? TimeTracker.Activity.PING : TimeTracker.Activity.SEARCH);
        return new Parameters(t.eventname(), m);
    }

    private long preMeasure(boolean doIt) {
        if (doIt) {
            return System.currentTimeMillis();
        }
        return 0L;
    }

    private void postMeasure(boolean doIt, long start) {
        if (doIt) {
            long elapsed = System.currentTimeMillis() - start;
            this.measurements.put((double)elapsed);
        }
    }

    @Override
    public void fill(Result result, String summaryClass, Execution execution) {
        long start = this.preMeasure(this.measureFill);
        super.fill(result, summaryClass, execution);
        this.postMeasure(this.measureFill, start);
    }

    @Override
    public Pong ping(Ping ping, Execution execution) {
        long start = this.preMeasure(this.measurePing);
        Pong pong = execution.ping(ping);
        this.postMeasure(this.measurePing, start);
        return pong;
    }

    @Override
    public Result search(Query query, Execution execution) {
        long start = this.preMeasure(this.measureSearch);
        Result result = execution.search(query);
        this.postMeasure(this.measureSearch, start);
        return result;
    }

    public void setMeasurements(Value measurements) {
        this.measurements = measurements;
    }

    public void deconstruct() {
        this.measurements.cancel();
        super.deconstruct();
    }

    public static class Parameters {
        final String eventName;
        final TimeTracker.Activity pathToSample;

        public Parameters(String eventName, TimeTracker.Activity pathToSample) {
            this.eventName = eventName;
            this.pathToSample = pathToSample;
        }
    }
}

