/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.grouping.vespa;

import com.yahoo.search.grouping.vespa.IntegerDecoder;
import com.yahoo.search.grouping.vespa.IntegerEncoder;
import java.util.Arrays;

class ResultId {
    private final int[] indexes;
    private final int hashCode;

    private ResultId(int[] indexes) {
        this.indexes = indexes;
        this.hashCode = Arrays.hashCode(indexes);
    }

    public boolean startsWith(int ... prefix) {
        if (prefix.length > this.indexes.length) {
            return false;
        }
        for (int i = 0; i < prefix.length; ++i) {
            if (prefix[i] == this.indexes[i]) continue;
            return false;
        }
        return true;
    }

    public ResultId newChildId(int childIdx) {
        int[] arr = Arrays.copyOf(this.indexes, this.indexes.length + 1);
        arr[this.indexes.length] = childIdx;
        return new ResultId(arr);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        return obj instanceof ResultId && Arrays.equals(this.indexes, ((ResultId)obj).indexes);
    }

    public String toString() {
        return Arrays.toString(this.indexes);
    }

    public void encode(IntegerEncoder out) {
        out.append(this.indexes.length);
        for (int i : this.indexes) {
            out.append(i);
        }
    }

    public static ResultId decode(IntegerDecoder in) {
        int len = in.next();
        int[] arr = new int[len];
        for (int i = 0; i < len; ++i) {
            arr[i] = in.next();
        }
        return new ResultId(arr);
    }

    public static ResultId valueOf(int ... indexes) {
        return new ResultId(Arrays.copyOf(indexes, indexes.length));
    }
}

