/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.query;

import com.yahoo.prelude.query.AndItem;
import com.yahoo.prelude.query.CompositeItem;
import com.yahoo.prelude.query.EquivItem;
import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.NotItem;
import com.yahoo.prelude.query.OrItem;
import com.yahoo.prelude.query.PhraseItem;
import com.yahoo.prelude.query.RankItem;

public class TermType {
    public static final TermType RANK = new TermType("rank", RankItem.class, null, "$");
    public static final TermType AND = new TermType("and", AndItem.class, null, "+");
    public static final TermType OR = new TermType("or", OrItem.class, null, "?");
    public static final TermType NOT = new TermType("not", NotItem.class, null, "-");
    public static final TermType PHRASE = new TermType("phrase", PhraseItem.class, null, "\"");
    public static final TermType EQUIV = new TermType("equiv", EquivItem.class, null, "");
    public static final TermType DEFAULT = new TermType("", CompositeItem.class, AndItem.class, "");
    public final String name;
    private final String sign;
    private final Class<? extends CompositeItem> instanceClass;
    private final Class<? extends CompositeItem> itemClass;

    private TermType(String name, Class<? extends CompositeItem> itemClass, Class<? extends CompositeItem> instanceClass, String sign) {
        this.name = name;
        this.itemClass = itemClass;
        this.instanceClass = instanceClass == null ? itemClass : instanceClass;
        this.sign = sign;
    }

    public String getName() {
        return this.name;
    }

    public Class<? extends CompositeItem> getItemClass() {
        return this.itemClass;
    }

    public boolean hasItemClass(Class<?> theClass) {
        return this.getItemClass() == theClass;
    }

    public Item createItemClass() {
        try {
            return this.instanceClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create an instance for item " + this, e);
        }
    }

    public String toSign() {
        return this.sign;
    }

    public boolean equals(Object o) {
        if (!(o instanceof TermType)) {
            return false;
        }
        TermType other = (TermType)o;
        return this.name.equals(other.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return "term type '" + this.name + "'";
    }
}

