/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.fastsearch;

import com.yahoo.data.access.Inspector;
import com.yahoo.prelude.fastsearch.Base64DataField;
import com.yahoo.prelude.fastsearch.BoolField;
import com.yahoo.prelude.fastsearch.ByteField;
import com.yahoo.prelude.fastsearch.DataField;
import com.yahoo.prelude.fastsearch.DoubleField;
import com.yahoo.prelude.fastsearch.FeatureDataField;
import com.yahoo.prelude.fastsearch.Float16Field;
import com.yahoo.prelude.fastsearch.FloatField;
import com.yahoo.prelude.fastsearch.Int64Field;
import com.yahoo.prelude.fastsearch.IntegerField;
import com.yahoo.prelude.fastsearch.LongdataField;
import com.yahoo.prelude.fastsearch.LongstringField;
import com.yahoo.prelude.fastsearch.ShortField;
import com.yahoo.prelude.fastsearch.StringField;
import com.yahoo.prelude.fastsearch.StructDataField;
import com.yahoo.prelude.fastsearch.TensorField;
import com.yahoo.prelude.fastsearch.XMLField;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class DocsumField {
    private static final Logger log = Logger.getLogger(DocsumField.class.getName());
    private static FieldFactory fieldFactory = new FieldFactory();
    protected String name;

    protected DocsumField(String name) {
        this.name = name;
    }

    public static DocsumField create(String name, String typename) {
        try {
            return fieldFactory.create(typename, name);
        }
        catch (Exception e) {
            throw new RuntimeException("Unknown field type '" + typename + "'", e);
        }
    }

    public String getName() {
        return this.name;
    }

    public abstract Object convert(Inspector var1);

    boolean isString() {
        return false;
    }

    static {
        try {
            fieldFactory.put("bool", BoolField.class);
            fieldFactory.put("byte", ByteField.class);
            fieldFactory.put("short", ShortField.class);
            fieldFactory.put("integer", IntegerField.class);
            fieldFactory.put("int64", Int64Field.class);
            fieldFactory.put("float16", Float16Field.class);
            fieldFactory.put("float", FloatField.class);
            fieldFactory.put("double", DoubleField.class);
            fieldFactory.put("string", StringField.class);
            fieldFactory.put("data", DataField.class);
            fieldFactory.put("raw", Base64DataField.class);
            fieldFactory.put("longstring", LongstringField.class);
            fieldFactory.put("longdata", LongdataField.class);
            fieldFactory.put("jsonstring", StructDataField.class);
            fieldFactory.put("featuredata", FeatureDataField.class);
            fieldFactory.put("xmlstring", XMLField.class);
            fieldFactory.put("tensor", TensorField.class);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Could not initialize docsum decoding properly.", e);
        }
    }

    private static class FieldFactory {
        Map<String, Constructor<? extends DocsumField>> constructors = new HashMap<String, Constructor<? extends DocsumField>>();

        private FieldFactory() {
        }

        void put(String typename, Class<? extends DocsumField> fieldClass) throws NoSuchMethodException, SecurityException {
            Constructor<? extends DocsumField> constructor = fieldClass.getConstructor(String.class);
            this.constructors.put(typename, constructor);
        }

        DocsumField create(String typename, String name) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            DocsumField f = this.constructors.get(typename).newInstance(name);
            return f;
        }
    }
}

