/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.searchers;

import com.google.common.annotations.Beta;
import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.NearestNeighborItem;
import com.yahoo.prelude.query.ToolBox;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.Searcher;
import com.yahoo.search.query.ranking.RankProperties;
import com.yahoo.search.result.ErrorMessage;
import com.yahoo.search.searchchain.Execution;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorType;
import com.yahoo.vespa.config.search.AttributesConfig;
import com.yahoo.yolean.chain.After;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@After(value={"queryCanonicalization"})
@Beta
public class ValidateNearestNeighborSearcher
extends Searcher {
    private Map<String, TensorType> validAttributes = new HashMap<String, TensorType>();

    public ValidateNearestNeighborSearcher(AttributesConfig attributesConfig) {
        for (AttributesConfig.Attribute a : attributesConfig.attribute()) {
            TensorType tt = null;
            if (a.datatype() == AttributesConfig.Attribute.Datatype.TENSOR) {
                tt = TensorType.fromSpec((String)a.tensortype());
            }
            this.validAttributes.put(a.name(), tt);
        }
    }

    @Override
    public Result search(Query query, Execution execution) {
        Optional<ErrorMessage> e = this.validate(query);
        return e.isEmpty() ? execution.search(query) : new Result(query, e.get());
    }

    private Optional<ErrorMessage> validate(Query query) {
        NNVisitor visitor = new NNVisitor(query.getRanking().getProperties(), this.validAttributes);
        ToolBox.visit(visitor, query.getModel().getQueryTree().getRoot());
        return visitor.errorMessage;
    }

    private static class NNVisitor
    extends ToolBox.QueryVisitor {
        public Optional<ErrorMessage> errorMessage = Optional.empty();
        private RankProperties rankProperties;
        private Map<String, TensorType> validAttributes;

        public NNVisitor(RankProperties rankProperties, Map<String, TensorType> validAttributes) {
            this.rankProperties = rankProperties;
            this.validAttributes = validAttributes;
        }

        @Override
        public boolean visit(Item item) {
            if (item instanceof NearestNeighborItem) {
                this.validate((NearestNeighborItem)item);
            }
            return true;
        }

        private void setError(String description) {
            this.errorMessage = Optional.of(ErrorMessage.createIllegalQuery(description));
        }

        private static boolean isCompatible(TensorType lhs, TensorType rhs) {
            return lhs.dimensions().equals(rhs.dimensions());
        }

        private static boolean isDenseVector(TensorType tt) {
            List dims = tt.dimensions();
            if (dims.size() != 1) {
                return false;
            }
            for (TensorType.Dimension d : dims) {
                if (d.type() == TensorType.Dimension.Type.indexedBound) continue;
                return false;
            }
            return true;
        }

        private void validate(NearestNeighborItem item) {
            int target = item.getTargetNumHits();
            if (target < 1) {
                this.setError(item.toString() + " has invalid targetNumHits");
                return;
            }
            String qprop = item.getQueryTensorName();
            List<Object> rankPropValList = this.rankProperties.asMap().get(qprop);
            if (rankPropValList == null) {
                this.setError(item.toString() + " query tensor not found");
                return;
            }
            if (rankPropValList.size() != 1) {
                this.setError(item.toString() + " query tensor does not have a single value");
                return;
            }
            Object rankPropValue = rankPropValList.get(0);
            if (!(rankPropValue instanceof Tensor)) {
                this.setError(item.toString() + " query tensor should be a tensor, was: " + (rankPropValue == null ? "null" : rankPropValue.getClass().toString()));
                return;
            }
            Tensor qTensor = (Tensor)rankPropValue;
            TensorType qTensorType = qTensor.type();
            String field = item.getIndexName();
            if (this.validAttributes.containsKey(field)) {
                TensorType fTensorType = this.validAttributes.get(field);
                if (fTensorType == null) {
                    this.setError(item.toString() + " field is not a tensor");
                    return;
                }
                if (!NNVisitor.isCompatible(fTensorType, qTensorType)) {
                    this.setError(item.toString() + " field type " + fTensorType + " does not match query tensor type " + qTensorType);
                    return;
                }
                if (!NNVisitor.isDenseVector(fTensorType)) {
                    this.setError(item.toString() + " tensor type " + fTensorType + " is not a dense vector");
                    return;
                }
            } else {
                this.setError(item.toString() + " field is not an attribute");
                return;
            }
        }

        @Override
        public void onExit() {
        }
    }
}

