/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.query.profile;

import com.yahoo.processing.request.CompoundName;
import com.yahoo.search.query.profile.DimensionBinding;
import com.yahoo.search.query.profile.DimensionValues;
import com.yahoo.search.query.profile.QueryProfile;
import com.yahoo.search.query.profile.QueryProfileVisitor;

abstract class PrefixQueryProfileVisitor
extends QueryProfileVisitor {
    private final CompoundName prefix;
    protected CompoundName currentPrefix = CompoundName.empty;
    private int prefixComponentIndex = -1;

    public PrefixQueryProfileVisitor(CompoundName prefix) {
        if (prefix == null) {
            prefix = CompoundName.empty;
        }
        this.prefix = prefix;
    }

    @Override
    public final void onQueryProfile(QueryProfile profile, DimensionBinding binding, QueryProfile owner, DimensionValues variant) {
        if (this.prefixComponentIndex < this.prefix.size()) {
            return;
        }
        this.onQueryProfileInsidePrefix(profile, binding, owner, variant);
    }

    protected abstract void onQueryProfileInsidePrefix(QueryProfile var1, DimensionBinding var2, QueryProfile var3, DimensionValues var4);

    @Override
    public final boolean enter(String name) {
        ++this.prefixComponentIndex;
        if (this.prefixComponentIndex - 1 < this.prefix.size()) {
            return true;
        }
        this.currentPrefix = this.currentPrefix.append(name);
        return true;
    }

    @Override
    public final void leave(String name) {
        --this.prefixComponentIndex;
        if (this.prefixComponentIndex < this.prefix.size()) {
            return;
        }
        if (!name.isEmpty() && !this.currentPrefix.isEmpty()) {
            this.currentPrefix = this.currentPrefix.first(this.currentPrefix.size() - 1);
        }
    }

    @Override
    public String getLocalKey() {
        if (this.prefixComponentIndex < this.prefix.size()) {
            return this.prefix.get(this.prefixComponentIndex);
        }
        return null;
    }
}

