/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.dispatch.rpc;

import com.google.common.collect.ImmutableMap;
import com.yahoo.compress.CompressionType;
import com.yahoo.compress.Compressor;
import com.yahoo.processing.request.CompoundName;
import com.yahoo.search.Query;
import com.yahoo.search.dispatch.rpc.Client;
import com.yahoo.search.dispatch.rpc.RpcClient;
import com.yahoo.vespa.config.search.DispatchConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class RpcResourcePool {
    public static final CompoundName dispatchCompression = new CompoundName("dispatch.compression");
    private final Compressor compressor = new Compressor(CompressionType.LZ4, 5, 0.95, 32);
    private final Random random = new Random();
    private final ImmutableMap<Integer, NodeConnectionPool> nodeConnectionPools;

    public RpcResourcePool(Map<Integer, Client.NodeConnection> nodeConnections) {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        nodeConnections.forEach((key, connection) -> builder.put(key, (Object)new NodeConnectionPool(Collections.singletonList(connection))));
        this.nodeConnectionPools = builder.build();
    }

    public RpcResourcePool(DispatchConfig dispatchConfig) {
        RpcClient client = new RpcClient(dispatchConfig.numJrtTransportThreads());
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        int numConnections = dispatchConfig.numJrtConnectionsPerNode();
        for (DispatchConfig.Node node : dispatchConfig.node()) {
            ArrayList<Client.NodeConnection> connections = new ArrayList<Client.NodeConnection>(numConnections);
            for (int i = 0; i < numConnections; ++i) {
                connections.add(client.createConnection(node.host(), node.port()));
            }
            builder.put((Object)node.key(), (Object)new NodeConnectionPool(connections));
        }
        this.nodeConnectionPools = builder.build();
    }

    public Compressor compressor() {
        return this.compressor;
    }

    public Compressor.Compression compress(Query query, byte[] payload) {
        CompressionType compression = CompressionType.valueOf((String)query.properties().getString(dispatchCompression, "LZ4").toUpperCase());
        return this.compressor.compress(compression, payload);
    }

    public Client.NodeConnection getConnection(int nodeId) {
        NodeConnectionPool pool = (NodeConnectionPool)this.nodeConnectionPools.get((Object)nodeId);
        if (pool == null) {
            return null;
        }
        return pool.nextConnection();
    }

    public void release() {
        this.nodeConnectionPools.values().forEach(NodeConnectionPool::release);
    }

    private class NodeConnectionPool {
        private final List<Client.NodeConnection> connections;

        NodeConnectionPool(List<Client.NodeConnection> connections) {
            this.connections = connections;
        }

        Client.NodeConnection nextConnection() {
            int slot = RpcResourcePool.this.random.nextInt(this.connections.size());
            return this.connections.get(slot);
        }

        void release() {
            this.connections.forEach(Client.NodeConnection::close);
        }
    }
}

