/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.query;

import com.google.common.annotations.Beta;
import com.yahoo.compress.IntegerCompressor;
import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.SimpleTaggableItem;
import java.nio.ByteBuffer;

@Beta
public class NearestNeighborItem
extends SimpleTaggableItem {
    private int targetNumHits = 0;
    private String field;
    private String queryTensorName;

    public NearestNeighborItem(String fieldName, String queryTensorName) {
        this.field = fieldName;
        this.queryTensorName = queryTensorName;
    }

    public int getTargetNumHits() {
        return this.targetNumHits;
    }

    public String getIndexName() {
        return this.field;
    }

    public String getQueryTensorName() {
        return this.queryTensorName;
    }

    public void setTargetNumHits(int target) {
        this.targetNumHits = target;
    }

    @Override
    public void setIndexName(String index) {
        this.field = index;
    }

    @Override
    public Item.ItemType getItemType() {
        return Item.ItemType.NEAREST_NEIGHBOR;
    }

    @Override
    public String getName() {
        return "NEAREST_NEIGHBOR";
    }

    @Override
    public int getTermCount() {
        return 1;
    }

    @Override
    public int encode(ByteBuffer buffer) {
        super.encodeThis(buffer);
        NearestNeighborItem.putString(this.field, buffer);
        NearestNeighborItem.putString(this.queryTensorName, buffer);
        IntegerCompressor.putCompressedPositiveNumber((int)this.targetNumHits, (ByteBuffer)buffer);
        return 1;
    }

    @Override
    protected void appendBodyString(StringBuilder buffer) {
        buffer.append("{field=").append(this.field);
        buffer.append(",queryTensorName=").append(this.queryTensorName);
        buffer.append(",targetNumHits=").append(this.targetNumHits).append("}");
    }
}

