/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.cluster;

import com.yahoo.component.ComponentId;
import com.yahoo.component.chain.dependencies.After;
import com.yahoo.component.provider.ComponentRegistry;
import com.yahoo.container.QrSearchersConfig;
import com.yahoo.container.handler.VipStatus;
import com.yahoo.prelude.IndexFacts;
import com.yahoo.prelude.fastsearch.ClusterParams;
import com.yahoo.prelude.fastsearch.DocumentdbInfoConfig;
import com.yahoo.prelude.fastsearch.FS4ResourcePool;
import com.yahoo.prelude.fastsearch.FastSearcher;
import com.yahoo.prelude.fastsearch.SummaryParameters;
import com.yahoo.prelude.fastsearch.VespaBackEndSearcher;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.Searcher;
import com.yahoo.search.config.ClusterConfig;
import com.yahoo.search.dispatch.Dispatcher;
import com.yahoo.search.query.ParameterParser;
import com.yahoo.search.result.ErrorMessage;
import com.yahoo.search.searchchain.Execution;
import com.yahoo.vespa.streamingvisitors.VdsStreamingSearcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@After(value={"*"})
public class ClusterSearcher
extends Searcher {
    private final String searchClusterName;
    private final Set<String> documentTypes;
    private final Map<String, Set<String>> rankProfiles = new HashMap<String, Set<String>>();
    private final long maxQueryTimeout;
    private static final long DEFAULT_MAX_QUERY_TIMEOUT = 600000L;
    private final long maxQueryCacheTimeout;
    private static final long DEFAULT_MAX_QUERY_CACHE_TIMEOUT = 10000L;
    private VespaBackEndSearcher server = null;

    public ClusterSearcher(ComponentId id, QrSearchersConfig qrsConfig, ClusterConfig clusterConfig, DocumentdbInfoConfig documentDbConfig, ComponentRegistry<Dispatcher> dispatchers, FS4ResourcePool fs4ResourcePool, VipStatus vipStatus) {
        super(id);
        VespaBackEndSearcher searcher;
        int searchClusterIndex = clusterConfig.clusterId();
        this.searchClusterName = clusterConfig.clusterName();
        QrSearchersConfig.Searchcluster searchClusterConfig = ClusterSearcher.getSearchClusterConfigFromClusterName(qrsConfig, this.searchClusterName);
        this.documentTypes = new LinkedHashSet<String>();
        this.maxQueryTimeout = ParameterParser.asMilliSeconds(clusterConfig.maxQueryTimeout(), 600000L);
        this.maxQueryCacheTimeout = ParameterParser.asMilliSeconds(clusterConfig.maxQueryCacheTimeout(), 10000L);
        SummaryParameters docSumParams = new SummaryParameters(qrsConfig.com().yahoo().prelude().fastsearch().FastSearcher().docsum().defaultclass());
        for (DocumentdbInfoConfig.Documentdb docDb : documentDbConfig.documentdb()) {
            String docTypeName = docDb.name();
            this.documentTypes.add(docTypeName);
            for (DocumentdbInfoConfig.Documentdb.Rankprofile profile : docDb.rankprofile()) {
                this.addValidRankProfile(profile.name(), docTypeName);
            }
        }
        if (searchClusterConfig.indexingmode() == QrSearchersConfig.Searchcluster.Indexingmode.STREAMING) {
            searcher = ClusterSearcher.vdsCluster(fs4ResourcePool.getServerId(), searchClusterIndex, searchClusterConfig, docSumParams, documentDbConfig);
            this.addBackendSearcher(searcher);
            vipStatus.addToRotation(searcher.getName());
        } else {
            searcher = ClusterSearcher.searchDispatch(searchClusterIndex, this.searchClusterName, fs4ResourcePool.getServerId(), docSumParams, documentDbConfig, dispatchers);
            this.addBackendSearcher(searcher);
        }
        if (this.server == null) {
            throw new IllegalStateException("ClusterSearcher should have backend.");
        }
    }

    private static QrSearchersConfig.Searchcluster getSearchClusterConfigFromClusterName(QrSearchersConfig config, String name) {
        for (QrSearchersConfig.Searchcluster searchCluster : config.searchcluster()) {
            if (!searchCluster.name().equals(name)) continue;
            return searchCluster;
        }
        return null;
    }

    private static ClusterParams makeClusterParams(int searchclusterIndex) {
        return new ClusterParams("sc" + searchclusterIndex + ".num0");
    }

    private static FastSearcher searchDispatch(int searchclusterIndex, String searchClusterName, String serverId, SummaryParameters docSumParams, DocumentdbInfoConfig documentdbInfoConfig, ComponentRegistry<Dispatcher> dispatchers) {
        ClusterParams clusterParams = ClusterSearcher.makeClusterParams(searchclusterIndex);
        ComponentId dispatcherComponentId = new ComponentId("dispatcher." + searchClusterName);
        Dispatcher dispatcher = (Dispatcher)((Object)dispatchers.getComponent(dispatcherComponentId));
        if (dispatcher == null) {
            throw new IllegalArgumentException("Configuration error: No dispatcher " + dispatcherComponentId + " is configured");
        }
        return new FastSearcher(serverId, dispatcher, docSumParams, clusterParams, documentdbInfoConfig);
    }

    private static VdsStreamingSearcher vdsCluster(String serverId, int searchclusterIndex, QrSearchersConfig.Searchcluster searchClusterConfig, SummaryParameters docSumParams, DocumentdbInfoConfig documentdbInfoConfig) {
        if (searchClusterConfig.searchdef().size() != 1) {
            throw new IllegalArgumentException("Search clusters in streaming search shall only contain a single searchdefinition : " + searchClusterConfig.searchdef());
        }
        ClusterParams clusterParams = ClusterSearcher.makeClusterParams(searchclusterIndex);
        VdsStreamingSearcher searcher = new VdsStreamingSearcher();
        searcher.setSearchClusterConfigId(searchClusterConfig.rankprofiles().configid());
        searcher.setDocumentType(searchClusterConfig.searchdef(0));
        searcher.setStorageClusterRouteSpec(searchClusterConfig.storagecluster().routespec());
        searcher.init(serverId, docSumParams, clusterParams, documentdbInfoConfig);
        return searcher;
    }

    ClusterSearcher(Set<String> documentTypes) {
        this.documentTypes = documentTypes;
        this.searchClusterName = "testScenario";
        this.maxQueryTimeout = 600000L;
        this.maxQueryCacheTimeout = 10000L;
    }

    void addBackendSearcher(VespaBackEndSearcher searcher) {
        this.server = searcher;
    }

    void addValidRankProfile(String profileName, String docTypeName) {
        if (!this.rankProfiles.containsKey(profileName)) {
            this.rankProfiles.put(profileName, new HashSet());
        }
        this.rankProfiles.get(profileName).add(docTypeName);
    }

    void setValidRankProfile(String profileName, Set<String> documentTypes) {
        this.rankProfiles.put(profileName, documentTypes);
    }

    private Result checkValidRankProfiles(Query query, Set<String> docTypes) {
        String rankProfile = query.getRanking().getProfile();
        Set<String> invalidInDocTypes = null;
        Set<String> rankDocTypes = this.rankProfiles.get(rankProfile);
        if (rankDocTypes == null) {
            invalidInDocTypes = docTypes;
        } else if (docTypes.size() == 1) {
            if (!rankDocTypes.contains(docTypes.iterator().next())) {
                invalidInDocTypes = docTypes;
            }
        } else {
            Set<String> restrict = query.getModel().getRestrict();
            Set<String> sources = query.getModel().getSources();
            boolean validate = restrict != null && !restrict.isEmpty();
            boolean bl = validate = validate || sources != null && !sources.isEmpty();
            if (validate && !rankDocTypes.containsAll(docTypes)) {
                invalidInDocTypes = new HashSet<String>(docTypes);
                invalidInDocTypes.removeAll(rankDocTypes);
            }
        }
        if (invalidInDocTypes != null && !invalidInDocTypes.isEmpty()) {
            String plural = invalidInDocTypes.size() > 1 ? "s" : "";
            return new Result(query, ErrorMessage.createInvalidQueryParameter("Requested rank profile '" + rankProfile + "' is undefined for document type" + plural + " '" + String.join((CharSequence)", ", invalidInDocTypes) + "'"));
        }
        return null;
    }

    @Override
    public void fill(Result result, String summaryClass, Execution execution) {
        Query query = result.getQuery();
        VespaBackEndSearcher searcher = this.server;
        if (searcher != null) {
            if (query.getTimeLeft() > 0L) {
                searcher.fill(result, summaryClass, execution);
            } else if (result.hits().getErrorHit() == null) {
                result.hits().addError(ErrorMessage.createTimeout("No time left to get summaries, query timeout was " + query.getTimeout() + " ms"));
            }
        } else if (result.hits().getErrorHit() == null) {
            result.hits().addError(ErrorMessage.createNoBackendsInService("Could not fill result"));
        }
    }

    @Override
    public Result search(Query query, Execution execution) {
        this.validateQueryTimeout(query);
        this.validateQueryCache(query);
        VespaBackEndSearcher searcher = this.server;
        if (searcher == null) {
            return new Result(query, ErrorMessage.createNoBackendsInService("Could not search"));
        }
        if (query.getTimeLeft() <= 0L) {
            return new Result(query, ErrorMessage.createTimeout("No time left for searching"));
        }
        return this.doSearch(searcher, query, execution);
    }

    private void validateQueryTimeout(Query query) {
        if (query.getTimeout() <= this.maxQueryTimeout) {
            return;
        }
        if (query.isTraceable(2)) {
            query.trace("Query timeout (" + query.getTimeout() + " ms) > max query timeout (" + this.maxQueryTimeout + " ms). Setting timeout to " + this.maxQueryTimeout + " ms.", 2);
        }
        query.setTimeout(this.maxQueryTimeout);
    }

    private void validateQueryCache(Query query) {
        if (!query.getRanking().getQueryCache()) {
            return;
        }
        if (query.getTimeout() <= this.maxQueryCacheTimeout) {
            return;
        }
        if (query.isTraceable(2)) {
            query.trace("Query timeout (" + query.getTimeout() + " ms) > max query cache timeout (" + this.maxQueryCacheTimeout + " ms). Disabling query cache.", 2);
        }
        query.getRanking().setQueryCache(false);
    }

    private Result doSearch(Searcher searcher, Query query, Execution execution) {
        if (this.documentTypes.size() > 1) {
            return this.searchMultipleDocumentTypes(searcher, query, execution);
        }
        String docType = this.documentTypes.iterator().next();
        Result invalidRankProfile = this.checkValidRankProfiles(query, this.documentTypes);
        if (invalidRankProfile != null) {
            return invalidRankProfile;
        }
        query.getModel().setRestrict(docType);
        return searcher.search(query, execution);
    }

    private Result searchMultipleDocumentTypes(Searcher searcher, Query query, Execution execution) {
        Set<String> docTypes = this.resolveDocumentTypes(query, execution.context().getIndexFacts());
        Result invalidRankProfile = this.checkValidRankProfiles(query, docTypes);
        if (invalidRankProfile != null) {
            return invalidRankProfile;
        }
        List<Query> queries = this.createQueries(query, docTypes);
        if (queries.size() == 1) {
            return searcher.search(queries.get(0), execution);
        }
        Result mergedResult = new Result(query);
        for (Query q : queries) {
            Result result = searcher.search(q, execution);
            mergedResult.mergeWith(result);
            mergedResult.hits().addAll(result.hits().asUnorderedHits());
        }
        if (query.getOffset() > 0 || query.getHits() < mergedResult.hits().size()) {
            if (mergedResult.getHitOrderer() != null) {
                searcher.fill(mergedResult, "attributeprefetch", execution);
            }
            mergedResult.hits().trim(query.getOffset(), query.getHits());
            query.setOffset(0);
        }
        return mergedResult;
    }

    Set<String> resolveDocumentTypes(Query query, IndexFacts indexFacts) {
        Set<String> restrict = query.getModel().getRestrict();
        if (restrict == null || restrict.isEmpty()) {
            Set<String> sources = query.getModel().getSources();
            return sources == null || sources.isEmpty() ? this.documentTypes : new HashSet<String>(indexFacts.newSession(sources, Collections.emptyList(), this.documentTypes).documentTypes());
        }
        return this.filterValidDocumentTypes(restrict);
    }

    private Set<String> filterValidDocumentTypes(Collection<String> restrict) {
        LinkedHashSet<String> retval = new LinkedHashSet<String>();
        for (String docType : restrict) {
            if (docType == null || !this.documentTypes.contains(docType)) continue;
            retval.add(docType);
        }
        return retval;
    }

    private List<Query> createQueries(Query query, Set<String> docTypes) {
        query.getModel().getQueryTree();
        ArrayList<Query> retval = new ArrayList<Query>(docTypes.size());
        if (docTypes.size() == 1) {
            query.getModel().setRestrict(docTypes.iterator().next());
            retval.add(query);
        } else if (!docTypes.isEmpty()) {
            for (String docType : docTypes) {
                Query q = query.clone();
                q.setOffset(0);
                q.setHits(query.getOffset() + query.getHits());
                q.getModel().setRestrict(docType);
                retval.add(q);
            }
        }
        return retval;
    }

    public void deconstruct() {
        if (this.server != null) {
            this.server.shutDown();
        }
    }
}

