/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.yql;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.yahoo.search.yql.Operator;
import com.yahoo.search.yql.OperatorNode;
import com.yahoo.search.yql.OperatorTypeChecker;
import java.util.Set;

class NodeTypeChecker
extends OperatorTypeChecker {
    private final Class<? extends Operator> operatorType;
    private final Set<? extends Operator> operators;

    public NodeTypeChecker(Operator parent, int idx, Class<? extends Operator> operatorType, Set<? extends Operator> operators) {
        super(parent, idx);
        this.operatorType = operatorType;
        this.operators = operators;
    }

    @Override
    public void check(Object argument) {
        Preconditions.checkNotNull((Object)argument, (String)"Argument %s of %s must not be null", (Object[])new Object[]{this.idx, this.parent});
        Preconditions.checkArgument((boolean)(argument instanceof OperatorNode), (String)"Argument %s of %s must be an OperatorNode<%s> (is %s).", (Object[])new Object[]{this.idx, this.parent, this.operatorType.getName(), argument.getClass()});
        OperatorNode node = (OperatorNode)argument;
        Object op = node.getOperator();
        Preconditions.checkArgument((boolean)this.operatorType.isInstance(op), (String)"Argument %s of %s must be an OperatorNode<%s> (is: %s).", (Object[])new Object[]{this.idx, this.parent, this.operatorType.getName(), op.getClass()});
        if (!this.operators.isEmpty()) {
            Preconditions.checkArgument((boolean)this.operators.contains(op), (String)"Argument %s of %s must be %s (is %s).", (Object[])new Object[]{this.idx, this.parent, Joiner.on((String)"|").join(this.operators), op});
        }
    }
}

