/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.yql;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.yahoo.search.yql.Operator;
import com.yahoo.search.yql.OperatorTypeChecker;
import java.util.Set;

public class JavaUnionTypeChecker
extends OperatorTypeChecker {
    private final Set<Class<?>> types;

    public JavaUnionTypeChecker(Operator parent, int idx, Set<Class<?>> types) {
        super(parent, idx);
        this.types = types;
    }

    public JavaUnionTypeChecker(Operator parent, int idx, Class<?> ... types) {
        super(parent, idx);
        this.types = ImmutableSet.copyOf((Object[])types);
    }

    @Override
    public void check(Object argument) {
        Preconditions.checkNotNull((Object)argument, (String)"Argument %s of %s must not be null", (Object[])new Object[]{this.idx, this.parent});
        for (Class<?> candidate : this.types) {
            if (!candidate.isInstance(argument)) continue;
            return;
        }
        Preconditions.checkArgument((boolean)false, (String)"Argument %s of %s must be %s (is: %s).", (Object[])new Object[]{this.idx, this.parent, Joiner.on((String)"|").join(this.types), argument.getClass()});
    }
}

