/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.yql;

import com.google.common.annotations.Beta;
import com.yahoo.component.chain.dependencies.After;
import com.yahoo.component.chain.dependencies.Before;
import com.yahoo.processing.request.CompoundName;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.Searcher;
import com.yahoo.search.result.Hit;
import com.yahoo.search.searchchain.Execution;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

@After(value={"ExternalYql"})
@Before(value={"com.yahoo.search.yql.FieldFiller"})
@Beta
public class FieldFilter
extends Searcher {
    public static final CompoundName FIELD_FILTER_DISABLE = new CompoundName("FieldFilter.disable");

    @Override
    public Result search(Query query, Execution execution) {
        Result result = execution.search(query);
        this.filter(result);
        return result;
    }

    @Override
    public void fill(Result result, String summaryClass, Execution execution) {
        execution.fill(result, summaryClass);
        this.filter(result);
    }

    private void filter(Result result) {
        if (result.getQuery().properties().getBoolean(FIELD_FILTER_DISABLE)) {
            return;
        }
        if (result.getQuery().getPresentation().getSummaryFields().isEmpty()) {
            return;
        }
        Set<String> requestedFields = result.getQuery().getPresentation().getSummaryFields();
        Iterator<Hit> i = result.hits().unorderedDeepIterator();
        while (i.hasNext()) {
            Hit h = i.next();
            if (h.isMeta()) continue;
            Iterator<Map.Entry<String, Object>> fields = h.fieldIterator();
            while (fields.hasNext()) {
                Map.Entry<String, Object> field = fields.next();
                if (requestedFields.contains(field.getKey())) continue;
                fields.remove();
            }
        }
    }
}

