/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.statistics;

import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.EnumNode;
import com.yahoo.config.InnerNode;
import com.yahoo.config.InnerNodeVector;
import com.yahoo.config.StringNode;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class TimingSearcherConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "12b8312539a6c3ab6c464c48e5d36b7b";
    public static final String CONFIG_DEF_NAME = "timing-searcher";
    public static final String CONFIG_DEF_NAMESPACE = "search.statistics";
    public static final String CONFIG_DEF_VERSION = "";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=search.statistics", "timer[].name string", "timer[].eventname string", "timer[].measure enum { FILL, PING, SEARCH } default=SEARCH"};
    private final InnerNodeVector<Timer> timer;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public static String getDefVersion() {
        return CONFIG_DEF_VERSION;
    }

    public TimingSearcherConfig(Builder builder) {
        this(builder, true);
    }

    private TimingSearcherConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for timing-searcher must be initialized: " + builder.__uninitialized);
        }
        this.timer = Timer.createVector(builder.timer);
    }

    public List<Timer> timer() {
        return this.timer;
    }

    public Timer timer(int i) {
        return (Timer)((Object)this.timer.get(i));
    }

    private ChangesRequiringRestart getChangesRequiringRestart(TimingSearcherConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static final class Timer
    extends InnerNode {
        private final StringNode name;
        private final StringNode eventname;
        private final Measure measure;

        @Deprecated
        private Timer() {
            this(new Builder(), false);
        }

        public Timer(Builder builder) {
            this(builder, true);
        }

        private Timer(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for timing-searcher.timer[] must be initialized: " + builder.__uninitialized);
            }
            this.name = builder.name == null ? new StringNode() : new StringNode(builder.name);
            this.eventname = builder.eventname == null ? new StringNode() : new StringNode(builder.eventname);
            this.measure = builder.measure == null ? new Measure(Measure.SEARCH) : new Measure(builder.measure);
        }

        public String name() {
            return this.name.value();
        }

        public String eventname() {
            return this.eventname.value();
        }

        public Measure.Enum measure() {
            return (Measure.Enum)((Object)this.measure.value());
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Timer newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("timer");
            return changes;
        }

        private static InnerNodeVector<Timer> createVector(List<Builder> builders) {
            ArrayList<Timer> elems = new ArrayList<Timer>();
            for (Builder b : builders) {
                elems.add(new Timer(b));
            }
            return new InnerNodeVector(elems, (InnerNode)new Timer());
        }

        public static final class Measure
        extends EnumNode<Enum> {
            public static final Enum FILL = Enum.FILL;
            public static final Enum PING = Enum.PING;
            public static final Enum SEARCH = Enum.SEARCH;

            public Measure() {
                this.value = null;
            }

            public Measure(Enum enumValue) {
                super(enumValue != null);
                this.value = enumValue;
            }

            protected boolean doSetValue(@NonNull String name) {
                try {
                    this.value = Enum.valueOf(name);
                    return true;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return false;
                }
            }

            public static enum Enum {
                FILL,
                PING,
                SEARCH;

            }
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("name", "eventname"));
            private String name = null;
            private String eventname = null;
            private Measure.Enum measure = null;

            public Builder() {
            }

            public Builder(Timer config) {
                this.name(config.name());
                this.eventname(config.eventname());
                this.measure(config.measure());
            }

            private Builder override(Builder __superior) {
                if (__superior.name != null) {
                    this.name(__superior.name);
                }
                if (__superior.eventname != null) {
                    this.eventname(__superior.eventname);
                }
                if (__superior.measure != null) {
                    this.measure(__superior.measure);
                }
                return this;
            }

            public Builder name(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.name = __value;
                this.__uninitialized.remove("name");
                return this;
            }

            public Builder eventname(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.eventname = __value;
                this.__uninitialized.remove("eventname");
                return this;
            }

            public Builder measure(Measure.Enum __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.measure = __value;
                return this;
            }

            private Builder measure(String __value) {
                return this.measure(Measure.Enum.valueOf(__value));
            }
        }
    }

    public static class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        public List<Timer.Builder> timer = new ArrayList<Timer.Builder>();

        public Builder() {
        }

        public Builder(TimingSearcherConfig config) {
            for (Timer t : config.timer()) {
                this.timer(new Timer.Builder(t));
            }
        }

        private Builder override(Builder __superior) {
            if (!__superior.timer.isEmpty()) {
                this.timer.addAll(__superior.timer);
            }
            return this;
        }

        public Builder timer(Timer.Builder __builder) {
            this.timer.add(__builder);
            return this;
        }

        public Builder timer(List<Timer.Builder> __builders) {
            this.timer = __builders;
            return this;
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return TimingSearcherConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return TimingSearcherConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return TimingSearcherConfig.CONFIG_DEF_NAMESPACE;
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

